/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.ui.AddGroupRule;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddGroupEvent extends DocumentEventBase {
	private PersonDocumentGroup group;

	public AddGroupEvent(String errorPathPrefix, IdentityManagementPersonDocument document) {
        super("adding group document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddGroupEvent(String errorPathPrefix, Document document, PersonDocumentGroup group) {
        this(errorPathPrefix, (IdentityManagementPersonDocument) document);
        this.group = group;
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddGroupRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddGroupRule) rule).processAddGroup(this);
    }

	public PersonDocumentGroup getGroup() {
		return this.group;
	}

	public void setGroup(PersonDocumentGroup group) {
		this.group = group;
	}

}
