/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpression;
import org.kuali.rice.kew.rule.RuleExpressionResult;

class RuleImpl
implements Rule {
    public static final String DEFAULT_RULE_EXPRESSION = "WorkflowAttribute";
    private static final String RULE_EXPRESSION_PACKAGE = "org.kuali.rice.kew.rule";
    private static final String RULE_EXPRESSION_SUFFIX = "RuleExpression";
    private final org.kuali.rice.kew.api.rule.Rule ruleDefinition;

    RuleImpl(org.kuali.rice.kew.api.rule.Rule ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    public org.kuali.rice.kew.api.rule.Rule getDefinition() {
        return this.ruleDefinition;
    }

    protected RuleExpression loadRuleExpression(String type) {
        RuleExpression ruleExpression;
        Class<?> ruleExpressionClass;
        int colon;
        if (type == null) {
            type = DEFAULT_RULE_EXPRESSION;
        }
        if ((colon = type.indexOf(58)) == -1) {
            colon = type.length();
        }
        type = type.substring(0, colon);
        type = StringUtils.capitalize((String)type);
        String className = "org.kuali.rice.kew.rule." + type + RULE_EXPRESSION_SUFFIX;
        try {
            ruleExpressionClass = ClassLoaderUtils.getDefaultClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RiceIllegalStateException("Rule expression implementation '" + className + "' not found", (Throwable)cnfe);
        }
        if (!RuleExpression.class.isAssignableFrom(ruleExpressionClass)) {
            throw new RiceIllegalStateException("Specified class '" + String.valueOf(ruleExpressionClass) + "' does not implement RuleExpression interface");
        }
        try {
            ruleExpression = (RuleExpression)ruleExpressionClass.newInstance();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RiceIllegalStateException("Error instantiating rule expression implementation '" + String.valueOf(ruleExpressionClass) + "'", (Throwable)e);
        }
        return ruleExpression;
    }

    @Override
    public RuleExpressionResult evaluate(Rule rule, RouteContext context) {
        org.kuali.rice.kew.api.rule.RuleExpression ruleExprDef = this.ruleDefinition.getRuleExpressionDef();
        String type = DEFAULT_RULE_EXPRESSION;
        if (ruleExprDef != null) {
            type = ruleExprDef.getType();
        }
        RuleExpression ruleExpression = this.loadRuleExpression(type);
        return ruleExpression.evaluate(rule, context);
    }
}

