/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.transition;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.*;

import java.util.ArrayList;
import java.util.List;


/**
 * Handles transitions into and out of {@link SplitNode} nodes.
 * 
 * @see SplitNode
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SplitTransitionEngine extends TransitionEngine {
	
    @Override
    public ProcessResult isComplete(RouteContext context) throws Exception {
        SplitNode node = (SplitNode)getNode(context.getNodeInstance().getRouteNode(), SplitNode.class);
        return node.process(context, getRouteHelper());
    }
    
	@Override
    public Transition transitionFrom(RouteContext context, ProcessResult processResult)
			throws Exception {
		RouteNodeInstance splitInstance = context.getNodeInstance();
		List<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
        SplitResult result = (SplitResult)processResult;
        for (String branchName : result.getBranchNames())
        {
            for (RouteNode routeNode : splitInstance.getRouteNode().getNextNodes())
            {
                if (routeNode.getBranch() != null && routeNode.getBranch().getName().equals(branchName))
                {
                    nextNodeInstances.add(createSplitChild(branchName, routeNode, splitInstance));
                }
            }
        }
		return new Transition(nextNodeInstances);
	}
	
	public static RouteNodeInstance createSplitChild(String branchName, RouteNode routeNode, RouteNodeInstance splitInstance) {
	    RouteHelper routeHelper = new RouteHelper();
	    RouteNodeInstance nextNodeInstance = routeHelper.getNodeFactory().createRouteNodeInstance(splitInstance.getDocumentId(), routeNode);
		Branch branch = routeHelper.getNodeFactory().createBranch(branchName, splitInstance.getBranch(), nextNodeInstance);
		branch.setSplitNode(splitInstance);
		nextNodeInstance.setBranch(branch);
		nextNodeInstance.setProcess(splitInstance.getProcess());
		return nextNodeInstance;
	}
	
}
