/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.responsibility;

import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddResponsibilityEvent extends DocumentEventBase {
	private KimDocumentRoleResponsibility permission;

	public AddResponsibilityEvent(String errorPathPrefix, IdentityManagementRoleDocument document) {
        super("adding Responsibility document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddResponsibilityEvent(String errorPathPrefix, Document document, KimDocumentRoleResponsibility permission) {
        this(errorPathPrefix, (IdentityManagementRoleDocument) document);
        this.permission = KradDataServiceLocator.getDataObjectService().copyInstance(permission);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddResponsibilityRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddResponsibilityRule) rule).processAddResponsibility(this);
    }

	public KimDocumentRoleResponsibility getResponsibility() {
		return this.permission;
	}

	public void setResponsibility(KimDocumentRoleResponsibility permission) {
		this.permission = permission;
	}

}
