/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.exporter;

import org.kuali.rice.kns.datadictionary.TransactionalDocumentEntry;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;

/**
 * TransactionalDocumentEntryMapper
 *
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class TransactionalDocumentEntryMapper extends DocumentEntryMapper {

    /**
     * @param entry
     * @return Map containing a String- and Map-based representation of the given entry
     */
    public ExportMap mapEntry(TransactionalDocumentEntry entry) {
        ExportMap entryMap = super.mapEntry(entry);

        // simple properties
        entryMap.set("transactionalDocument", "true");
        entryMap.set("documentClass", entry.getDocumentClass().getName());
        entryMap.set("allowsCopy", Boolean.toString(entry.getAllowsCopy()));

        return entryMap;
    }

}
