/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.web.RuleQuickLinksForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;

public class RuleQuickLinksAction
extends KewKualiAction {
    private static final Logger LOG = LogManager.getLogger(RuleQuickLinksAction.class);
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private DocumentHelperService documentHelperService;

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.makeLookupPathParam(mapping, request);
        this.establishRequiredState(request, form);
        return mapping.findForward("basic");
    }

    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        List<Object> documentTypes;
        RuleQuickLinksForm qlForm = (RuleQuickLinksForm)form;
        if (qlForm.getRootDocTypeName() != null) {
            documentTypes = new ArrayList();
            DocumentType docType = this.getDocumentTypeService().findByName(qlForm.getRootDocTypeName());
            documentTypes.add(docType);
            request.setAttribute("renderOpened", (Object)Boolean.TRUE);
        } else {
            documentTypes = this.getDocumentTypeService().findAllCurrentRootDocuments();
        }
        qlForm.setDocumentTypeQuickLinksStructures(this.getDocumentTypeDataStructure(documentTypes));
        int shouldDisplayCount = 0;
        for (DocumentTypeQuickLinksStructure dt : qlForm.getDocumentTypeQuickLinksStructures()) {
            if (!dt.isShouldDisplay()) continue;
            ++shouldDisplayCount;
        }
        if (shouldDisplayCount == 1) {
            request.setAttribute("renderOpened", (Object)Boolean.TRUE);
        }
        String documentTypeName = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(DocumentType.class);
        try {
            if (documentTypeName != null && this.getDocumentHelperService().getDocumentAuthorizer(documentTypeName).canInitiate(documentTypeName, GlobalVariables.getUserSession().getPerson())) {
                qlForm.setCanInitiateDocumentTypeDocument(true);
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to check initiation permission for " + documentTypeName, (Throwable)ex);
        }
        return null;
    }

    public ActionForward addDelegationRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward result = null;
        String ruleTemplateId = request.getParameter("delegationRule.ruleTemplate.id");
        String docTypeName = request.getParameter("delegationRule.documentType.name");
        List<RuleBaseValues> rules = this.getRuleService().search(docTypeName, null, ruleTemplateId, "", null, null, Boolean.FALSE, Boolean.TRUE, new HashMap(), null);
        if (rules.size() == 1) {
            RuleBaseValues rule = rules.get(0);
            String url = ConfigContext.getCurrentContextConfig().getKEWBaseURL() + "/DelegateRule.do?methodToCall=start&parentRuleId=" + rule.getId();
            result = new ActionForward(url, true);
        } else {
            this.makeLookupPathParam(mapping, request);
            result = new ActionForward(ConfigContext.getCurrentContextConfig().getKRBaseURL() + "/lookup.do?methodToCall=start&" + this.stripMethodToCall(request.getQueryString()), true);
        }
        return result;
    }

    private List getDocumentTypeDataStructure(List rootDocuments) {
        ArrayList<DocumentTypeQuickLinksStructure> documentTypeQuickLinksStructures = new ArrayList<DocumentTypeQuickLinksStructure>();
        Iterator iter = rootDocuments.iterator();
        while (iter.hasNext()) {
            DocumentTypeQuickLinksStructure quickLinkStruct = new DocumentTypeQuickLinksStructure((DocumentType)iter.next());
            if (quickLinkStruct.getFlattenedNodes().isEmpty() && quickLinkStruct.getChildrenDocumentTypes().isEmpty()) continue;
            documentTypeQuickLinksStructures.add(quickLinkStruct);
        }
        return documentTypeQuickLinksStructures;
    }

    private void makeLookupPathParam(ActionMapping mapping, HttpServletRequest request) {
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + mapping.getModuleConfig().getPrefix();
        request.setAttribute("basePath", (Object)basePath);
    }

    private String stripMethodToCall(String queryString) {
        return queryString.replaceAll("methodToCall=addDelegationRule&", "");
    }

    private DocumentTypeService getDocumentTypeService() {
        return KEWServiceLocator.getDocumentTypeService();
    }

    private RuleServiceInternal getRuleService() {
        return KEWServiceLocator.getRuleService();
    }

    public DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.establishRequiredState(request, form);
        return super.toggleTab(mapping, form, request, response);
    }

    public static class DocumentTypeQuickLinksStructure {
        private DocumentType documentType;
        private List<RouteNode> flattenedNodes = new ArrayList<RouteNode>();
        private List<DocumentTypeQuickLinksStructure> childrenDocumentTypes = new ArrayList<DocumentTypeQuickLinksStructure>();
        private List<Permission> permissions = null;

        private DocumentTypeQuickLinksStructure(DocumentType documentType) {
            this.documentType = documentType;
            if (documentType != null) {
                List<RouteNode> tempFlattenedNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, true);
                for (RouteNode routeNode : tempFlattenedNodes) {
                    if (!routeNode.isFlexRM() && !routeNode.isRoleNode()) continue;
                    this.flattenedNodes.add(new RouteNodeForDisplay(routeNode));
                }
                Iterator<DocumentType> iter = documentType.getChildrenDocTypes().iterator();
                while (iter.hasNext()) {
                    this.childrenDocumentTypes.add(new DocumentTypeQuickLinksStructure(iter.next()));
                }
                Collections.sort(this.childrenDocumentTypes, new Comparator(this){

                    public int compare(Object o1, Object o2) {
                        return ((DocumentTypeQuickLinksStructure)o1).documentType.getLabel().compareTo(((DocumentTypeQuickLinksStructure)o2).documentType.getLabel());
                    }
                });
            }
        }

        public List getChildrenDocumentTypes() {
            return this.childrenDocumentTypes;
        }

        public void setChildrenDocumentTypes(List<DocumentTypeQuickLinksStructure> childrenDocumentTypes) {
            this.childrenDocumentTypes = childrenDocumentTypes;
        }

        public DocumentType getDocumentType() {
            return this.documentType;
        }

        public void setDocumentType(DocumentType documentType) {
            this.documentType = documentType;
        }

        public List getFlattenedNodes() {
            return this.flattenedNodes;
        }

        public void setFlattenedNodes(List<RouteNode> flattenedNodes) {
            this.flattenedNodes = flattenedNodes;
        }

        public boolean isShouldDisplay() {
            return true;
        }

        public List<Permission> getPermissions() {
            if (this.permissions == null) {
                Predicate p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"attributeName", (Object)"documentTypeName"), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE), PredicateFactory.equal((String)"detailCriteria", (Object)("documentTypeName=" + this.getDocumentType().getName()))});
                this.permissions = KimApiServiceLocator.getPermissionService().findPermissions(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{p})).getResults();
            }
            return this.permissions;
        }

        public boolean isHasRelatedPermissions() {
            return !this.getPermissions().isEmpty();
        }

        public int getRelatedPermissionCount() {
            return this.getPermissions().size();
        }
    }

    public static class RouteNodeForDisplay
    extends RouteNode {
        private static final long serialVersionUID = 1L;
        private RouteNode baseNode;
        private List<Responsibility> responsibilities = null;

        public RouteNodeForDisplay(RouteNode baseNode) {
            this.baseNode = baseNode;
        }

        public boolean equals(Object obj) {
            return this.baseNode.equals(obj);
        }

        @Override
        public String getActivationType() {
            return this.baseNode.getActivationType();
        }

        @Override
        public BranchPrototype getBranch() {
            return this.baseNode.getBranch();
        }

        @Override
        public List<RouteNodeConfigParam> getConfigParams() {
            return this.baseNode.getConfigParams();
        }

        @Override
        public String getContentFragment() {
            return this.baseNode.getContentFragment();
        }

        @Override
        public DocumentType getDocumentType() {
            return this.baseNode.getDocumentType();
        }

        @Override
        public String getDocumentTypeId() {
            return this.baseNode.getDocumentTypeId();
        }

        @Override
        public Group getExceptionWorkgroup() {
            return this.baseNode.getExceptionWorkgroup();
        }

        @Override
        public String getExceptionWorkgroupId() {
            return this.baseNode.getExceptionWorkgroupId();
        }

        @Override
        public String getExceptionWorkgroupName() {
            return this.baseNode.getExceptionWorkgroupName();
        }

        @Override
        public Boolean getFinalApprovalInd() {
            return this.baseNode.getFinalApprovalInd();
        }

        @Override
        public Integer getLockVerNbr() {
            return this.baseNode.getLockVerNbr();
        }

        @Override
        public Boolean getMandatoryRouteInd() {
            return this.baseNode.getMandatoryRouteInd();
        }

        @Override
        public List<RouteNode> getNextNodes() {
            return this.baseNode.getNextNodes();
        }

        @Override
        public String getNodeType() {
            return this.baseNode.getNodeType();
        }

        @Override
        public List<RouteNode> getPreviousNodes() {
            return this.baseNode.getPreviousNodes();
        }

        @Override
        public String getRouteMethodCode() {
            return this.baseNode.getRouteMethodCode();
        }

        @Override
        public String getRouteMethodName() {
            return this.baseNode.getRouteMethodName();
        }

        @Override
        public String getRouteNodeId() {
            return this.baseNode.getRouteNodeId();
        }

        @Override
        public String getRouteNodeName() {
            return this.baseNode.getRouteNodeName();
        }

        @Override
        public RuleTemplateBo getRuleTemplate() {
            return this.baseNode.getRuleTemplate();
        }

        public int hashCode() {
            return this.baseNode.hashCode();
        }

        @Override
        public boolean isExceptionGroupDefined() {
            return this.baseNode.isExceptionGroupDefined();
        }

        @Override
        public boolean isFlexRM() {
            return this.baseNode.isFlexRM();
        }

        @Override
        public boolean isRoleNode() {
            return this.baseNode.isRoleNode();
        }

        @Override
        public String toString() {
            return this.baseNode.toString();
        }

        public List<Responsibility> getResponsibilities() {
            if (this.responsibilities == null) {
                QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
                Predicate p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"template.namespaceCode", (Object)"KR-WKFLW"), PredicateFactory.equal((String)"template.name", (Object)"Review"), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE), PredicateFactory.equal((String)"attributes[documentTypeName]", (Object)this.getDocumentType().getName())});
                builder.setPredicates(new Predicate[]{p});
                List possibleResponsibilities = KimApiServiceLocator.getResponsibilityService().findResponsibilities(builder.build()).getResults();
                if (!possibleResponsibilities.isEmpty()) {
                    for (Responsibility resp : possibleResponsibilities) {
                        String routeNodeName = (String)resp.getAttributes().get("routeNodeName");
                        if (!StringUtils.isNotEmpty((String)routeNodeName) || !StringUtils.equals((String)routeNodeName, (String)this.getRouteNodeName())) continue;
                        this.responsibilities.add(resp);
                    }
                } else {
                    this.responsibilities = possibleResponsibilities;
                }
            }
            return this.responsibilities;
        }

        public int getResponsibilityCount() {
            return this.getResponsibilities().size();
        }

        public boolean isHasResponsibility() {
            return !this.getResponsibilities().isEmpty();
        }
    }
}

