/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.bo.ui.GroupDocumentQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.bo.ui.PersonDocumentAddress;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.bo.ui.PersonDocumentPrivacy;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.group.GroupAttributeBo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.group.GroupInternalService;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.kim.impl.identity.IdentityArchiveService;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.kim.impl.role.RoleInternalService;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kns.datadictionary.exporter.AttributesMapBuilder;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;

public class UiDocumentServiceImpl
implements UiDocumentService {
    private static final Logger LOG = LogManager.getLogger(UiDocumentServiceImpl.class);
    private static final String SHOW_BLANK_QUALIFIERS = "kim.show.blank.qualifiers";
    private static final String KIM_IDENTITY_ARCHIVE_SERVICE = "kimIdentityArchiveService";
    private static final String PRINCIPALS = "principals.";
    private static final String KIM_ATTRIBUTE = "kimAttribute";
    private RoleService roleService;
    private RoleInternalService roleInternalService;
    private DataObjectService dataObjectService;
    private IdentityService identityService;
    private PermissionService permissionService;
    private GroupService groupService;
    private GroupInternalService groupInternalService;
    private ResponsibilityInternalService responsibilityInternalService;
    private KimTypeInfoService kimTypeInfoService;
    private DocumentHelperService documentHelperService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private IdentityArchiveService identityArchiveService;

    @Override
    public void saveEntityPerson(IdentityManagementPersonDocument identityManagementPersonDocument) {
        EntityBo kimEntity = new EntityBo();
        EntityBo origEntity = this.getEntityBo(identityManagementPersonDocument.getEntityId());
        boolean creatingNew = true;
        if (origEntity == null) {
            origEntity = new EntityBo();
            kimEntity.setActive(true);
        } else {
            kimEntity.setActive(origEntity.isActive());
            kimEntity.setVersionNumber(origEntity.getVersionNumber());
            creatingNew = false;
        }
        kimEntity.setId(identityManagementPersonDocument.getEntityId());
        String initiatorPrincipalId = this.getInitiatorPrincipalId((Document)identityManagementPersonDocument);
        boolean inactivatingPrincipal = false;
        if (this.canModifyEntity(initiatorPrincipalId, identityManagementPersonDocument.getPrincipalId())) {
            inactivatingPrincipal = this.setupPrincipal(identityManagementPersonDocument, kimEntity, origEntity.getPrincipals());
            this.setupAffiliation(identityManagementPersonDocument, kimEntity, origEntity.getAffiliations(), origEntity.getEmploymentInformation());
            this.setupName(identityManagementPersonDocument, kimEntity, origEntity.getNames());
            ArrayList<EntityTypeContactInfoBo> entityTypes = new ArrayList<EntityTypeContactInfoBo>();
            EntityTypeContactInfoBo entityType = new EntityTypeContactInfoBo();
            entityType.setEntityId(identityManagementPersonDocument.getEntityId());
            entityType.setEntityTypeCode("PERSON");
            entityType.setActive(true);
            entityTypes.add(entityType);
            EntityTypeContactInfoBo origEntityType = new EntityTypeContactInfoBo();
            for (EntityTypeContactInfoBo type : origEntity.getEntityTypeContactInfos()) {
                if (type.getEntityTypeCode() == null || !StringUtils.equals((String)type.getEntityTypeCode(), (String)entityType.getEntityTypeCode())) continue;
                origEntityType = type;
                entityType.setVersionNumber(type.getVersionNumber());
                entityType.setActive(type.isActive());
            }
            this.setupPhone(identityManagementPersonDocument, entityType, origEntityType.getPhoneNumbers());
            this.setupEmail(identityManagementPersonDocument, entityType, origEntityType.getEmailAddresses());
            this.setupAddress(identityManagementPersonDocument, entityType, origEntityType.getAddresses());
            kimEntity.setEntityTypeContactInfos(entityTypes);
        } else {
            if (ObjectUtils.isNotNull((Object)origEntity.getPrincipals())) {
                kimEntity.setPrincipals(origEntity.getPrincipals());
            }
            if (ObjectUtils.isNotNull((Object)origEntity.getExternalIdentifiers())) {
                kimEntity.setExternalIdentifiers(origEntity.getExternalIdentifiers());
            }
            if (ObjectUtils.isNotNull((Object)origEntity.getEmploymentInformation())) {
                kimEntity.setEmploymentInformation(origEntity.getEmploymentInformation());
            }
            if (ObjectUtils.isNotNull((Object)origEntity.getAffiliations())) {
                kimEntity.setAffiliations(origEntity.getAffiliations());
            }
            if (ObjectUtils.isNotNull((Object)origEntity.getNames())) {
                kimEntity.setNames(origEntity.getNames());
            }
            if (ObjectUtils.isNotNull((Object)origEntity.getEntityTypeContactInfos())) {
                kimEntity.setEntityTypeContactInfos(origEntity.getEntityTypeContactInfos());
            }
        }
        if (creatingNew || this.canOverrideEntityPrivacyPreferences(this.getInitiatorPrincipalId((Document)identityManagementPersonDocument), identityManagementPersonDocument.getPrincipalId())) {
            this.setupPrivacy(identityManagementPersonDocument, kimEntity, origEntity.getPrivacyPreferences());
        } else if (ObjectUtils.isNotNull((Object)origEntity.getPrivacyPreferences())) {
            kimEntity.setPrivacyPreferences(origEntity.getPrivacyPreferences());
        }
        kimEntity = (EntityBo)this.getDataObjectService().save((Object)kimEntity, new PersistenceOption[]{PersistenceOption.FLUSH});
        if (!inactivatingPrincipal) {
            List<GroupMemberBo> groupPrincipals = this.populateGroupMembers(identityManagementPersonDocument);
            List<RoleMemberBo> rolePrincipals = this.populateRoleMembers(identityManagementPersonDocument);
            List<DelegateTypeBo> personDelegations = this.populateDelegations(identityManagementPersonDocument);
            List<RoleResponsibilityActionBo> roleRspActions = this.populateRoleRspActions(identityManagementPersonDocument);
            ArrayList<Object> bos = new ArrayList<Object>();
            bos.addAll(groupPrincipals);
            bos.addAll(rolePrincipals);
            bos.addAll(roleRspActions);
            bos.addAll(personDelegations);
            for (Object e : bos) {
                this.getDataObjectService().save(e, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
            List<RoleMemberAttributeDataBo> blankRoleMemberAttrs = this.getBlankRoleMemberAttrs(rolePrincipals);
            if (!blankRoleMemberAttrs.isEmpty()) {
                for (RoleMemberAttributeDataBo blankRoleMemberAttr : blankRoleMemberAttrs) {
                    this.getDataObjectService().delete((Object)blankRoleMemberAttr);
                }
            }
        } else {
            this.getRoleInternalService().principalInactivated(identityManagementPersonDocument.getPrincipalId());
        }
    }

    private String getInitiatorPrincipalId(Document document) {
        try {
            return document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Map<String, Object> getAttributeEntries(List<KimAttributeField> definitions) {
        HashMap<String, Object> attributeEntries = new HashMap<String, Object>();
        if (definitions != null) {
            for (AttributeDefinition definition : DataDictionaryTypeServiceHelper.toKimAttributeDefinitions(definitions)) {
                AttributesMapBuilder builder = new AttributesMapBuilder();
                ExportMap map = builder.buildAttributeMap(definition, "");
                attributeEntries.put(definition.getName(), map.getExportData());
            }
        }
        return attributeEntries;
    }

    @Override
    public void loadEntityToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId) {
        Principal principal = this.getIdentityService().getPrincipal(principalId);
        Entity kimEntity = null;
        if (ObjectUtils.isNotNull((Object)principal)) {
            kimEntity = this.getIdentityService().getEntity(principal.getEntityId());
        }
        if (ObjectUtils.isNull((Object)principal) || ObjectUtils.isNull(kimEntity)) {
            IdentityArchiveService identityArchive = this.getIdentityArchiveService();
            EntityDefault entityInfo = identityArchive.getEntityDefaultFromArchiveByPrincipalId(principalId);
            principal = (Principal)entityInfo.getPrincipals().get(0);
            Entity.Builder eb = Entity.Builder.create();
            eb.setId(entityInfo.getEntityId());
            kimEntity = eb.build();
        }
        if (kimEntity == null) {
            throw new RuntimeException("Entity does not exist for principal id: " + principalId);
        }
        if (principal == null) {
            throw new RuntimeException("Principal does not exist for principal id:" + principalId);
        }
        identityManagementPersonDocument.setPrincipalId(principal.getPrincipalId());
        identityManagementPersonDocument.setPrincipalName(principal.getPrincipalName());
        identityManagementPersonDocument.setActive(principal.isActive());
        identityManagementPersonDocument.setEntityId(kimEntity.getId());
        if (ObjectUtils.isNotNull((Object)kimEntity.getPrivacyPreferences())) {
            identityManagementPersonDocument.setPrivacy(this.loadPrivacyReferences(kimEntity.getPrivacyPreferences()));
        }
        identityManagementPersonDocument.setAffiliations(this.loadAffiliations(kimEntity.getAffiliations(), kimEntity.getEmploymentInformation()));
        identityManagementPersonDocument.setNames(this.loadNames(identityManagementPersonDocument, principalId, kimEntity.getNames(), identityManagementPersonDocument.getPrivacy().isSuppressName()));
        EntityTypeContactInfo entityType = null;
        for (EntityTypeContactInfo type : kimEntity.getEntityTypeContactInfos()) {
            if (!"PERSON".equals(type.getEntityTypeCode())) continue;
            entityType = EntityTypeContactInfo.Builder.create((EntityTypeContactInfoContract)type).build();
        }
        if (entityType != null) {
            identityManagementPersonDocument.setEmails(this.loadEmails(identityManagementPersonDocument, principalId, entityType.getEmailAddresses(), identityManagementPersonDocument.getPrivacy().isSuppressEmail()));
            identityManagementPersonDocument.setPhones(this.loadPhones(identityManagementPersonDocument, principalId, entityType.getPhoneNumbers(), identityManagementPersonDocument.getPrivacy().isSuppressPhone()));
            identityManagementPersonDocument.setAddrs(this.loadAddresses(identityManagementPersonDocument, principalId, entityType.getAddresses(), identityManagementPersonDocument.getPrivacy().isSuppressAddress()));
        }
        List groups = this.getGroupService().getGroups((Collection)this.getGroupService().getDirectGroupIdsByPrincipalId(identityManagementPersonDocument.getPrincipalId()));
        this.loadGroupToPersonDoc(identityManagementPersonDocument, groups);
        this.loadRoleToPersonDoc(identityManagementPersonDocument);
        this.loadDelegationsToPersonDoc(identityManagementPersonDocument);
    }

    private List<DelegateTypeBo> getPersonDelegations(String principalId) {
        if (principalId == null) {
            return new ArrayList<DelegateTypeBo>();
        }
        List delegationMembers = this.getDataObjectService().findMatching(DelegateMemberBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"memberId", (Object)principalId), PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode())})).getResults();
        ArrayList<DelegateTypeBo> delegations = new ArrayList<DelegateTypeBo>();
        ArrayList<String> delegationIds = new ArrayList<String>();
        if (ObjectUtils.isNotNull((Object)delegationMembers)) {
            for (DelegateMemberBo delegationMember : delegationMembers) {
                if (delegationMember.getDelegationId() == null || delegationIds.contains(delegationMember.getDelegationId())) continue;
                delegationIds.add(delegationMember.getDelegationId());
                delegations.add((DelegateTypeBo)this.getDataObjectService().find(DelegateTypeBo.class, (Object)delegationMember.getDelegationId()));
            }
        }
        return delegations;
    }

    private void loadDelegationsToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument) {
        ArrayList<RoleDocumentDelegation> delList = new ArrayList<RoleDocumentDelegation>();
        List<DelegateTypeBo> origDelegations = this.getPersonDelegations(identityManagementPersonDocument.getPrincipalId());
        if (ObjectUtils.isNotNull(origDelegations)) {
            for (DelegateTypeBo del : origDelegations) {
                if (!del.isActive()) continue;
                RoleDocumentDelegation documentDelegation = new RoleDocumentDelegation();
                documentDelegation.setActive(del.isActive());
                documentDelegation.setDelegationId(del.getDelegationId());
                documentDelegation.setDelegationTypeCode(del.getDelegationTypeCode());
                documentDelegation.setKimTypeId(del.getKimTypeId());
                documentDelegation.setMembers(this.loadDelegationMembers(identityManagementPersonDocument, del.getMembers(), (Role)this.getMember(MemberType.ROLE, del.getRoleId())));
                documentDelegation.setRoleId(del.getRoleId());
                documentDelegation.setEdit(true);
                delList.add(documentDelegation);
            }
        }
        identityManagementPersonDocument.setDelegations(delList);
        this.setDelegationMembersInDocument(identityManagementPersonDocument);
    }

    private void setDelegationMembersInDocument(IdentityManagementPersonDocument identityManagementPersonDocument) {
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getDelegations())) {
            for (RoleDocumentDelegation delegation : identityManagementPersonDocument.getDelegations()) {
                if (!CollectionUtils.isNotEmpty(delegation.getMembers())) continue;
                for (RoleDocumentDelegationMember member : delegation.getMembers()) {
                    if (!StringUtils.equals((String)member.getMemberId(), (String)identityManagementPersonDocument.getPrincipalId())) continue;
                    member.setDelegationTypeCode(delegation.getDelegationTypeCode());
                    identityManagementPersonDocument.getDelegationMembers().add(member);
                }
            }
        }
    }

    private List<RoleDocumentDelegationMember> loadDelegationMembers(IdentityManagementPersonDocument identityManagementPersonDocument, List<DelegateMemberBo> members, Role roleImpl) {
        ArrayList<RoleDocumentDelegationMember> pndMembers = new ArrayList<RoleDocumentDelegationMember>();
        if (ObjectUtils.isNotNull(members)) {
            for (DelegateMemberBo member : members) {
                RoleDocumentDelegationMember pndMember = new RoleDocumentDelegationMember();
                pndMember.setActiveFromDate(member.getActiveFromDateValue());
                pndMember.setActiveToDate(member.getActiveToDateValue());
                pndMember.setActive(member.isActive(this.getDateTimeService().getCurrentTimestamp()));
                pndMember.setRoleBo(RoleBo.from((Role)roleImpl));
                if (!pndMember.isActive()) continue;
                pndMember.setMemberId(member.getMemberId());
                pndMember.setDelegationMemberId(member.getDelegationMemberId());
                pndMember.setMemberTypeCode(member.getType().getCode());
                pndMember.setDelegationId(member.getDelegationId());
                pndMember.setVersionNumber(member.getVersionNumber());
                pndMember.setObjectId(member.getObjectId());
                pndMember.setRoleMemberId(member.getRoleMemberId());
                RoleMemberBo roleMember = this.getRoleMemberForRoleMemberId(member.getRoleMemberId());
                if (roleMember != null) {
                    pndMember.setRoleMemberName(this.getMemberName(roleMember.getType(), roleMember.getMemberId()));
                    pndMember.setRoleMemberNamespaceCode(this.getMemberNamespaceCode(roleMember.getType(), roleMember.getMemberId()));
                }
                pndMember.setMemberNamespaceCode(this.getMemberNamespaceCode(member.getType(), member.getMemberId()));
                pndMember.setMemberName(this.getMemberName(member.getType(), member.getMemberId()));
                pndMember.setEdit(true);
                pndMember.setQualifiers(this.loadDelegationMemberQualifiers(identityManagementPersonDocument, pndMember.getAttributesHelper().getDefinitions(), member.getAttributeDetails()));
                pndMembers.add(pndMember);
            }
        }
        return pndMembers;
    }

    private List<RoleDocumentDelegationMemberQualifier> loadDelegationMemberQualifiers(IdentityManagementPersonDocument identityManagementPersonDocument, List<KimAttributeField> origAttributeDefinitions, List<DelegateMemberAttributeDataBo> attributeDataList) {
        ArrayList<RoleDocumentDelegationMemberQualifier> pndMemberRoleQualifiers = new ArrayList<RoleDocumentDelegationMemberQualifier>();
        boolean attributePresent = false;
        if (origAttributeDefinitions != null) {
            for (KimAttributeField key : origAttributeDefinitions) {
                RoleDocumentDelegationMemberQualifier pndMemberRoleQualifier;
                String origAttributeId = identityManagementPersonDocument.getKimAttributeDefnId(key);
                if (ObjectUtils.isNotNull(attributeDataList)) {
                    for (DelegateMemberAttributeDataBo memberRoleQualifier : attributeDataList) {
                        if (!StringUtils.equals((String)origAttributeId, (String)memberRoleQualifier.getKimAttribute().getId())) continue;
                        pndMemberRoleQualifier = new RoleDocumentDelegationMemberQualifier();
                        pndMemberRoleQualifier.setAttrDataId(memberRoleQualifier.getId());
                        pndMemberRoleQualifier.setAttrVal(memberRoleQualifier.getAttributeValue());
                        pndMemberRoleQualifier.setDelegationMemberId(memberRoleQualifier.getAssignedToId());
                        pndMemberRoleQualifier.setKimTypId(memberRoleQualifier.getKimTypeId());
                        pndMemberRoleQualifier.setKimAttrDefnId(memberRoleQualifier.getKimAttributeId());
                        pndMemberRoleQualifier.setKimAttribute(memberRoleQualifier.getKimAttribute());
                        pndMemberRoleQualifiers.add(pndMemberRoleQualifier);
                        attributePresent = true;
                    }
                }
                if (!attributePresent) {
                    pndMemberRoleQualifier = new RoleDocumentDelegationMemberQualifier();
                    pndMemberRoleQualifier.setKimAttrDefnId(origAttributeId);
                    pndMemberRoleQualifiers.add(pndMemberRoleQualifier);
                }
                attributePresent = false;
            }
        }
        return pndMemberRoleQualifiers;
    }

    private void loadGroupToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument, List<? extends Group> groups) {
        ArrayList<PersonDocumentGroup> docGroups = new ArrayList<PersonDocumentGroup>();
        if (ObjectUtils.isNotNull(groups)) {
            for (Group group : groups) {
                if (!this.getGroupService().isDirectMemberOfGroup(identityManagementPersonDocument.getPrincipalId(), group.getId())) continue;
                PersonDocumentGroup docGroup = new PersonDocumentGroup();
                docGroup.setGroupId(group.getId());
                docGroup.setGroupName(group.getName());
                docGroup.setNamespaceCode(group.getNamespaceCode());
                docGroup.setPrincipalId(identityManagementPersonDocument.getPrincipalId());
                List groupMemberships = this.getGroupService().getMembersOfGroup(group.getId());
                if (ObjectUtils.isNotNull((Object)groupMemberships)) {
                    for (GroupMember groupMember : groupMemberships) {
                        if (!StringUtils.equals((String)groupMember.getMemberId(), (String)identityManagementPersonDocument.getPrincipalId()) || !KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)groupMember.getType())) continue;
                        docGroup.setGroupMemberId(groupMember.getId());
                        if (groupMember.getActiveFromDate() != null) {
                            docGroup.setActiveFromDate(groupMember.getActiveFromDate() == null ? null : new Timestamp(groupMember.getActiveFromDate().getMillis()));
                        }
                        if (groupMember.getActiveToDate() == null) continue;
                        docGroup.setActiveToDate(groupMember.getActiveToDate() == null ? null : new Timestamp(groupMember.getActiveToDate().getMillis()));
                    }
                }
                docGroup.setKimTypeId(group.getKimTypeId());
                docGroup.setEdit(true);
                docGroups.add(docGroup);
            }
        }
        docGroups.sort(Comparator.comparing(PersonDocumentGroup::getGroupId));
        identityManagementPersonDocument.setGroups(docGroups);
    }

    private void loadRoleToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument) {
        ArrayList<PersonDocumentRole> docRoles = new ArrayList<PersonDocumentRole>();
        ArrayList<String> roleIds = new ArrayList<String>();
        List<RoleMemberBo> roleMembers = this.getRoleMembersForPrincipal(identityManagementPersonDocument.getPrincipalId());
        if (ObjectUtils.isNotNull(roleMembers)) {
            for (RoleMemberBo member : roleMembers) {
                if (!member.isActive() || roleIds.contains(member.getRoleId())) continue;
                this.loadDocRoles(docRoles, roleIds, member, roleMembers);
            }
        }
        for (PersonDocumentRole role : docRoles) {
            role.setDefinitions(this.getAttributeDefinitionsForRole(role));
            KimDocumentRoleMember newRolePrncpl = new KimDocumentRoleMember();
            newRolePrncpl.setMemberTypeCode(MemberType.PRINCIPAL.getCode());
            newRolePrncpl.setMemberId(identityManagementPersonDocument.getPrincipalId());
            role.setNewRolePrncpl(newRolePrncpl);
            if (role.getDefinitions() != null) {
                for (KimAttributeField key : role.getDefinitions()) {
                    KimDocumentRoleQualifier qualifier = new KimDocumentRoleQualifier();
                    this.setAttrDefnIdForQualifier(qualifier, key);
                    role.getNewRolePrncpl().getQualifiers().add(qualifier);
                }
            }
            this.loadRoleRstAction(role);
            role.setAttributeEntry(this.getAttributeEntries(role.getDefinitions()));
        }
        identityManagementPersonDocument.setRoles(docRoles);
    }

    private void loadDocRoles(List<PersonDocumentRole> docRoles, List<String> roleIds, RoleMemberBo member, List<RoleMemberBo> roleMembers) {
        RoleBoLite role = (RoleBoLite)this.getDataObjectService().find(RoleBoLite.class, (Object)member.getRoleId());
        ArrayList<RoleMemberBo> matchingMembers = new ArrayList<RoleMemberBo>();
        for (RoleMemberBo tempMember : roleMembers) {
            if (!tempMember.getRoleId().equals(member.getRoleId())) continue;
            matchingMembers.add(tempMember);
        }
        if (ObjectUtils.isNotNull((Object)role) && !roleIds.contains(role.getId())) {
            PersonDocumentRole docRole = new PersonDocumentRole();
            docRole.setKimTypeId(role.getKimTypeId());
            docRole.setActive(role.isActive());
            docRole.setNamespaceCode(role.getNamespaceCode());
            docRole.setEdit(true);
            docRole.setRoleId(role.getId());
            docRole.setRoleName(role.getName());
            docRole.setRolePrncpls(this.populateDocRolePrncpl(role.getNamespaceCode(), matchingMembers, member.getMemberId(), this.getAttributeDefinitionsForRole(docRole)));
            docRoles.add(docRole);
            roleIds.add(role.getId());
        }
    }

    private List<KimAttributeField> getAttributeDefinitionsForRole(PersonDocumentRole role) {
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)KimTypeBo.to((KimTypeBo)role.getKimRoleType()));
        try {
            if (kimTypeService != null) {
                return kimTypeService.getAttributeDefinitions(role.getKimTypeId());
            }
        }
        catch (Exception ex) {
            LOG.warn("Not able to retrieve KimTypeService from remote system for KIM Role Type: " + String.valueOf(role.getKimRoleType()), (Throwable)ex);
        }
        return Collections.emptyList();
    }

    private void loadRoleRstAction(PersonDocumentRole role) {
        if (role != null && CollectionUtils.isNotEmpty(role.getRolePrncpls())) {
            for (KimDocumentRoleMember roleMbr : role.getRolePrncpls()) {
                List<RoleResponsibilityActionBo> actions = this.getRoleRspActions(roleMbr.getRoleMemberId());
                if (!ObjectUtils.isNotNull(actions)) continue;
                for (RoleResponsibilityActionBo entRoleRspAction : actions) {
                    KimDocumentRoleResponsibilityAction roleRspAction = new KimDocumentRoleResponsibilityAction();
                    roleRspAction.setRoleResponsibilityActionId(entRoleRspAction.getId());
                    roleRspAction.setRoleResponsibilityId(entRoleRspAction.getRoleResponsibilityId());
                    roleRspAction.setActionTypeCode(entRoleRspAction.getActionTypeCode());
                    roleRspAction.setActionPolicyCode(entRoleRspAction.getActionPolicyCode());
                    roleRspAction.setPriorityNumber(entRoleRspAction.getPriorityNumber());
                    roleRspAction.setRoleResponsibilityActionId(entRoleRspAction.getId());
                    this.getDataObjectService().wrap((Object)roleRspAction).fetchRelationship("roleResponsibility");
                    roleMbr.getRoleRspActions().add(roleRspAction);
                }
            }
        }
    }

    private void setAttrDefnIdForQualifier(KimDocumentRoleQualifier qualifier, KimAttributeField definition) {
        qualifier.setKimAttrDefnId(this.getAttributeDefnId(definition));
        this.getDataObjectService().wrap((Object)qualifier).fetchRelationship(KIM_ATTRIBUTE);
    }

    private String getAttributeDefnId(KimAttributeField definition) {
        return definition.getId();
    }

    @Override
    public List<EntityEmployment> getEntityEmploymentInformationInfo(String entityId) {
        EntityBo entityImpl = this.getEntityBo(entityId);
        ArrayList<EntityEmployment> empInfos = new ArrayList<EntityEmployment>();
        if (entityImpl != null && CollectionUtils.isNotEmpty((Collection)entityImpl.getEmploymentInformation())) {
            for (EntityEmploymentBo empImpl : entityImpl.getEmploymentInformation()) {
                empInfos.add(EntityEmploymentBo.to((EntityEmploymentBo)empImpl));
            }
        }
        return empInfos;
    }

    private EntityBo getEntityBo(String entityId) {
        return (EntityBo)this.getDataObjectService().find(EntityBo.class, (Object)entityId);
    }

    private List<RoleBo> getRolesForPrincipal(String principalId) {
        if (principalId == null) {
            return new ArrayList<RoleBo>();
        }
        return this.getDataObjectService().findMatching(RoleBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"members.memberId", (Object)principalId), PredicateFactory.equal((String)"members.typeCode", (Object)MemberType.PRINCIPAL.getCode())})).getResults();
    }

    private List<RoleMemberBo> getRoleMembersForPrincipal(String principalId) {
        if (principalId == null) {
            return new ArrayList<RoleMemberBo>();
        }
        return this.getDataObjectService().findMatching(RoleMemberBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"memberId", (Object)principalId), PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode())})).getResults();
    }

    @Override
    public RoleMemberBo getRoleMember(String id) {
        if (id == null) {
            return null;
        }
        return (RoleMemberBo)this.getDataObjectService().find(RoleMemberBo.class, (Object)id);
    }

    private List<RoleResponsibilityActionBo> getRoleRspActions(String roleMemberId) {
        return this.getDataObjectService().findMatching(RoleResponsibilityActionBo.class, QueryByCriteria.Builder.forAttribute((String)"roleMemberId", (Object)roleMemberId).build()).getResults();
    }

    private List<KimDocumentRoleMember> populateDocRolePrncpl(String namespaceCode, List<RoleMemberBo> roleMembers, String principalId, List<KimAttributeField> definitions) {
        ArrayList<KimDocumentRoleMember> docRoleMembers = new ArrayList<KimDocumentRoleMember>();
        if (ObjectUtils.isNotNull(roleMembers)) {
            for (RoleMemberBo rolePrincipal : roleMembers) {
                if (!rolePrincipal.isActive(this.getDateTimeService().getCurrentTimestamp()) || !MemberType.PRINCIPAL.equals((Object)rolePrincipal.getType()) || !StringUtils.equals((String)rolePrincipal.getMemberId(), (String)principalId)) continue;
                KimDocumentRoleMember docRolePrncpl = new KimDocumentRoleMember();
                docRolePrncpl.setMemberId(rolePrincipal.getMemberId());
                docRolePrncpl.setRoleMemberId(rolePrincipal.getId());
                docRolePrncpl.setActive(rolePrincipal.isActive(this.getDateTimeService().getCurrentTimestamp()));
                docRolePrncpl.setRoleId(rolePrincipal.getRoleId());
                docRolePrncpl.setActiveFromDate(rolePrincipal.getActiveFromDateValue());
                docRolePrncpl.setActiveToDate(rolePrincipal.getActiveToDateValue());
                docRolePrncpl.setQualifiers(this.populateDocRoleQualifier(namespaceCode, rolePrincipal.getAttributeDetails(), definitions));
                docRolePrncpl.setEdit(true);
                docRoleMembers.add(docRolePrncpl);
            }
        }
        return docRoleMembers;
    }

    private List<KimDocumentRoleQualifier> populateDocRoleQualifier(String namespaceCode, List<RoleMemberAttributeDataBo> qualifiers, List<KimAttributeField> definitions) {
        ArrayList<KimDocumentRoleQualifier> docRoleQualifiers = new ArrayList<KimDocumentRoleQualifier>();
        if (definitions != null) {
            for (KimAttributeField definition : definitions) {
                String attrDefId = definition.getId();
                boolean qualifierFound = false;
                if (ObjectUtils.isNotNull(qualifiers)) {
                    for (RoleMemberAttributeDataBo qualifier : qualifiers) {
                        if (attrDefId == null || !StringUtils.equals((String)attrDefId, (String)qualifier.getKimAttributeId())) continue;
                        KimDocumentRoleQualifier docRoleQualifier = new KimDocumentRoleQualifier();
                        docRoleQualifier.setAttrDataId(qualifier.getId());
                        docRoleQualifier.setAttrVal(qualifier.getAttributeValue());
                        docRoleQualifier.setKimAttrDefnId(qualifier.getKimAttributeId());
                        docRoleQualifier.setKimAttribute(qualifier.getKimAttribute());
                        docRoleQualifier.setKimTypId(qualifier.getKimTypeId());
                        docRoleQualifier.setRoleMemberId(qualifier.getAssignedToId());
                        docRoleQualifier.setEdit(true);
                        this.formatAttrValIfNecessary(docRoleQualifier);
                        docRoleQualifiers.add(docRoleQualifier);
                        qualifierFound = true;
                        break;
                    }
                }
                if (qualifierFound) continue;
                KimDocumentRoleQualifier docRoleQualifier = new KimDocumentRoleQualifier();
                docRoleQualifier.setAttrVal("");
                docRoleQualifier.setKimAttrDefnId(attrDefId);
                this.getDataObjectService().wrap((Object)docRoleQualifier).fetchRelationship(KIM_ATTRIBUTE);
                docRoleQualifiers.add(docRoleQualifier);
            }
            if (!this.isBlankRoleQualifierVisible(namespaceCode)) {
                int qualCount = 0;
                for (KimDocumentRoleQualifier qual : docRoleQualifiers) {
                    if (!StringUtils.isEmpty((String)qual.getAttrVal())) continue;
                    ++qualCount;
                }
                if (qualCount == docRoleQualifiers.size()) {
                    return new ArrayList<KimDocumentRoleQualifier>();
                }
            }
        }
        return docRoleQualifiers;
    }

    private List<PersonDocumentName> loadNames(IdentityManagementPersonDocument personDoc, String principalId, List<EntityName> names, boolean suppressDisplay) {
        ArrayList<PersonDocumentName> docNames = new ArrayList<PersonDocumentName>();
        if (ObjectUtils.isNotNull(names)) {
            for (EntityName name : names) {
                if (!name.isActive()) continue;
                PersonDocumentName docName = new PersonDocumentName();
                if (name.getNameType() != null) {
                    docName.setNameCode(name.getNameType().getCode());
                }
                docName.setFirstName(name.getFirstNameUnmasked());
                docName.setLastName(name.getLastNameUnmasked());
                docName.setMiddleName(name.getMiddleNameUnmasked());
                docName.setNamePrefix(name.getNamePrefixUnmasked());
                docName.setNameSuffix(name.getNameSuffixUnmasked());
                docName.setActive(name.isActive());
                docName.setDflt(name.isDefaultValue());
                docName.setEdit(true);
                docName.setEntityNameId(name.getId());
                docNames.add(docName);
            }
        }
        return docNames;
    }

    @Override
    public boolean canModifyEntity(String currentUserPrincipalId, String toModifyPrincipalId) {
        return StringUtils.isNotBlank((String)currentUserPrincipalId) && StringUtils.isNotBlank((String)toModifyPrincipalId) && currentUserPrincipalId.equals(toModifyPrincipalId) || this.getPermissionService().isAuthorized(currentUserPrincipalId, "KR-IDM", "Modify Entity", Collections.singletonMap("principalId", currentUserPrincipalId));
    }

    @Override
    public boolean canOverrideEntityPrivacyPreferences(String currentUserPrincipalId, String toModifyPrincipalId) {
        return StringUtils.isNotBlank((String)currentUserPrincipalId) && StringUtils.isNotBlank((String)toModifyPrincipalId) && currentUserPrincipalId.equals(toModifyPrincipalId) || this.getPermissionService().isAuthorized(currentUserPrincipalId, "KR-IDM", "Override Entity Privacy Preferences", Collections.singletonMap("principalId", currentUserPrincipalId));
    }

    private boolean canAssignToRole(IdentityManagementRoleDocument document, String initiatorPrincipalId) {
        boolean rulePassed = true;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", document.getRoleNamespace());
        additionalPermissionDetails.put("roleName", document.getRoleName());
        if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Assign Role", initiatorPrincipalId, additionalPermissionDetails, null)) {
            rulePassed = false;
        }
        return rulePassed;
    }

    private List<PersonDocumentAffiliation> loadAffiliations(List<EntityAffiliation> affiliations, List<EntityEmployment> empInfos) {
        ArrayList<PersonDocumentAffiliation> docAffiliations = new ArrayList<PersonDocumentAffiliation>();
        if (ObjectUtils.isNotNull(affiliations)) {
            for (EntityAffiliation affiliation : affiliations) {
                if (!affiliation.isActive()) continue;
                PersonDocumentAffiliation docAffiliation = new PersonDocumentAffiliation();
                docAffiliation.setAffiliationTypeCode(affiliation.getAffiliationType().getCode());
                docAffiliation.setCampusCode(affiliation.getCampusCode());
                docAffiliation.setActive(affiliation.isActive());
                docAffiliation.setDflt(affiliation.isDefaultValue());
                docAffiliation.setEntityAffiliationId(affiliation.getId());
                this.getDataObjectService().wrap((Object)docAffiliation).fetchRelationship("affiliationType");
                docAffiliations.add(docAffiliation);
                docAffiliation.setEdit(true);
                ArrayList<PersonDocumentEmploymentInfo> docEmploymentInformations = new ArrayList<PersonDocumentEmploymentInfo>();
                if (ObjectUtils.isNotNull(empInfos)) {
                    for (EntityEmployment empInfo : empInfos) {
                        if (!empInfo.isActive() || !StringUtils.equals((String)docAffiliation.getEntityAffiliationId(), empInfo.getEntityAffiliation() != null ? empInfo.getEntityAffiliation().getId() : null)) continue;
                        PersonDocumentEmploymentInfo docEmpInfo = new PersonDocumentEmploymentInfo();
                        docEmpInfo.setEntityEmploymentId(empInfo.getId());
                        docEmpInfo.setEmployeeId(empInfo.getEmployeeId());
                        docEmpInfo.setEmploymentRecordId(empInfo.getEmploymentRecordId());
                        docEmpInfo.setBaseSalaryAmount(empInfo.getBaseSalaryAmount());
                        docEmpInfo.setPrimaryDepartmentCode(empInfo.getPrimaryDepartmentCode());
                        docEmpInfo.setEmploymentStatusCode(empInfo.getEmployeeStatus() != null ? empInfo.getEmployeeStatus().getCode() : null);
                        docEmpInfo.setEmploymentTypeCode(empInfo.getEmployeeType() != null ? empInfo.getEmployeeType().getCode() : null);
                        docEmpInfo.setActive(empInfo.isActive());
                        docEmpInfo.setPrimary(empInfo.isPrimary());
                        docEmpInfo.setEntityAffiliationId(empInfo.getEntityAffiliation() != null ? empInfo.getEntityAffiliation().getId() : null);
                        docEmpInfo.setEdit(true);
                        this.getDataObjectService().wrap((Object)docEmpInfo).fetchRelationship("employmentType");
                        docEmploymentInformations.add(docEmpInfo);
                    }
                }
                docAffiliation.setEmpInfos(docEmploymentInformations);
            }
        }
        return docAffiliations;
    }

    private boolean setupPrincipal(IdentityManagementPersonDocument identityManagementPersonDocument, EntityBo kimEntity, List<PrincipalBo> origPrincipals) {
        boolean inactivatingPrincipal = false;
        ArrayList<PrincipalBo> principals = new ArrayList<PrincipalBo>();
        PrincipalBo principal = new PrincipalBo();
        principal.setPrincipalName(identityManagementPersonDocument.getPrincipalName());
        principal.setPrincipalId(identityManagementPersonDocument.getPrincipalId());
        principal.setActive(identityManagementPersonDocument.isActive());
        principal.setEntityId(identityManagementPersonDocument.getEntityId());
        if (ObjectUtils.isNotNull(origPrincipals)) {
            for (PrincipalBo prncpl : origPrincipals) {
                if (prncpl.getPrincipalId() == null || !StringUtils.equals((String)prncpl.getPrincipalId(), (String)principal.getPrincipalId())) continue;
                principal.setVersionNumber(prncpl.getVersionNumber());
                principal.setObjectId(prncpl.getObjectId());
                principal.setPassword(prncpl.getPassword());
                if (!prncpl.isActive() || principal.isActive()) continue;
                inactivatingPrincipal = true;
            }
        }
        principals.add(principal);
        kimEntity.setPrincipals(principals);
        return inactivatingPrincipal;
    }

    private void setupPrivacy(IdentityManagementPersonDocument identityManagementPersonDocument, EntityBo kimEntity, EntityPrivacyPreferencesBo origPrivacy) {
        EntityPrivacyPreferencesBo privacyPreferences = new EntityPrivacyPreferencesBo();
        privacyPreferences.setEntityId(identityManagementPersonDocument.getEntityId());
        privacyPreferences.setSuppressAddress(identityManagementPersonDocument.getPrivacy().isSuppressAddress());
        privacyPreferences.setSuppressEmail(identityManagementPersonDocument.getPrivacy().isSuppressEmail());
        privacyPreferences.setSuppressName(identityManagementPersonDocument.getPrivacy().isSuppressName());
        privacyPreferences.setSuppressPhone(identityManagementPersonDocument.getPrivacy().isSuppressPhone());
        privacyPreferences.setSuppressPersonal(identityManagementPersonDocument.getPrivacy().isSuppressPersonal());
        if (ObjectUtils.isNotNull((Object)origPrivacy)) {
            privacyPreferences.setVersionNumber(origPrivacy.getVersionNumber());
            privacyPreferences.setObjectId(origPrivacy.getObjectId());
        }
        kimEntity.setPrivacyPreferences(privacyPreferences);
    }

    private PersonDocumentPrivacy loadPrivacyReferences(EntityPrivacyPreferences privacyPreferences) {
        PersonDocumentPrivacy docPrivacy = new PersonDocumentPrivacy();
        docPrivacy.setSuppressAddress(privacyPreferences.isSuppressAddress());
        docPrivacy.setSuppressEmail(privacyPreferences.isSuppressEmail());
        docPrivacy.setSuppressName(privacyPreferences.isSuppressName());
        docPrivacy.setSuppressPhone(privacyPreferences.isSuppressPhone());
        docPrivacy.setSuppressPersonal(privacyPreferences.isSuppressPersonal());
        docPrivacy.setEdit(true);
        return docPrivacy;
    }

    private void setupName(IdentityManagementPersonDocument identityManagementPersonDocument, EntityBo kimEntity, List<EntityNameBo> origNames) {
        if (!identityManagementPersonDocument.getPrivacy().isSuppressName() || this.canOverrideEntityPrivacyPreferences(this.getInitiatorPrincipalId((Document)identityManagementPersonDocument), identityManagementPersonDocument.getPrincipalId())) {
            ArrayList<EntityNameBo> entityNames = new ArrayList<EntityNameBo>();
            if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getNames())) {
                for (PersonDocumentName name : identityManagementPersonDocument.getNames()) {
                    EntityNameBo entityName = new EntityNameBo();
                    entityName.setNameCode(name.getNameCode());
                    if (name.getEntityNameType() != null) {
                        entityName.setNameType(name.getEntityNameType());
                    } else if (StringUtils.isNotEmpty((String)name.getNameCode())) {
                        entityName.setNameType(EntityNameTypeBo.from((CodedAttribute)this.getIdentityService().getNameType(name.getNameCode())));
                    }
                    entityName.setFirstName(name.getFirstName());
                    entityName.setLastName(name.getLastName());
                    entityName.setMiddleName(name.getMiddleName());
                    entityName.setNamePrefix(name.getNamePrefix());
                    entityName.setNameSuffix(name.getNameSuffix());
                    entityName.setActive(name.isActive());
                    entityName.setDefaultValue(name.isDflt());
                    entityName.setId(name.getEntityNameId());
                    entityName.setEntityId(identityManagementPersonDocument.getEntityId());
                    if (ObjectUtils.isNotNull(origNames)) {
                        for (EntityNameBo origName : origNames) {
                            if (origName.getId() == null || !StringUtils.equals((String)origName.getId(), (String)entityName.getId())) continue;
                            entityName.setVersionNumber(origName.getVersionNumber());
                        }
                    }
                    entityNames.add(entityName);
                }
            }
            kimEntity.setNames(entityNames);
        }
    }

    private void setupAffiliation(IdentityManagementPersonDocument identityManagementPersonDocument, EntityBo kimEntity, List<EntityAffiliationBo> origAffiliations, List<EntityEmploymentBo> origEmpInfos) {
        ArrayList<EntityAffiliationBo> entityAffiliations = new ArrayList<EntityAffiliationBo>();
        ArrayList<EntityEmploymentBo> entityEmploymentInformations = new ArrayList<EntityEmploymentBo>();
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getAffiliations())) {
            for (PersonDocumentAffiliation affiliation : identityManagementPersonDocument.getAffiliations()) {
                int employeeRecordCounter;
                EntityAffiliationBo entityAffiliation = new EntityAffiliationBo();
                entityAffiliation.setAffiliationTypeCode(affiliation.getAffiliationTypeCode());
                if (affiliation.getAffiliationType() != null) {
                    entityAffiliation.setAffiliationType(affiliation.getAffiliationType());
                } else if (StringUtils.isNotEmpty((String)affiliation.getAffiliationTypeCode())) {
                    entityAffiliation.setAffiliationType(EntityAffiliationTypeBo.from((EntityAffiliationType)this.getIdentityService().getAffiliationType(affiliation.getAffiliationTypeCode())));
                }
                entityAffiliation.setCampusCode(affiliation.getCampusCode());
                entityAffiliation.setActive(affiliation.isActive());
                entityAffiliation.setDefaultValue(affiliation.isDflt());
                entityAffiliation.setEntityId(identityManagementPersonDocument.getEntityId());
                entityAffiliation.setId(affiliation.getEntityAffiliationId());
                if (ObjectUtils.isNotNull(origAffiliations)) {
                    for (EntityAffiliationBo origAffiliation : origAffiliations) {
                        if (this.isSameAffiliation(origAffiliation, entityAffiliation)) {
                            entityAffiliation.setId(origAffiliation.getId());
                        }
                        if (origAffiliation.getId() == null || !StringUtils.equals((String)origAffiliation.getId(), (String)entityAffiliation.getId())) continue;
                        entityAffiliation.setVersionNumber(origAffiliation.getVersionNumber());
                    }
                }
                entityAffiliations.add(entityAffiliation);
                int n = employeeRecordCounter = origEmpInfos == null ? 0 : origEmpInfos.size();
                if (!CollectionUtils.isNotEmpty(affiliation.getEmpInfos())) continue;
                for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                    EntityEmploymentBo entityEmpInfo = new EntityEmploymentBo();
                    entityEmpInfo.setId(empInfo.getEntityEmploymentId());
                    entityEmpInfo.setEmployeeId(empInfo.getEmployeeId());
                    entityEmpInfo.setEmploymentRecordId(empInfo.getEmploymentRecordId());
                    entityEmpInfo.setBaseSalaryAmount(empInfo.getBaseSalaryAmount());
                    entityEmpInfo.setPrimaryDepartmentCode(empInfo.getPrimaryDepartmentCode());
                    entityEmpInfo.setEmployeeStatusCode(empInfo.getEmploymentStatusCode());
                    if (empInfo.getEmploymentStatus() != null) {
                        entityEmpInfo.setEmployeeStatus(empInfo.getEmploymentStatus());
                    } else if (StringUtils.isNotEmpty((String)empInfo.getEmploymentStatusCode())) {
                        entityEmpInfo.setEmployeeStatus(EntityEmploymentStatusBo.from((CodedAttribute)this.getIdentityService().getEmploymentStatus(empInfo.getEmploymentStatusCode())));
                    }
                    entityEmpInfo.setEmployeeTypeCode(empInfo.getEmploymentTypeCode());
                    if (empInfo.getEmploymentType() != null) {
                        entityEmpInfo.setEmployeeType(empInfo.getEmploymentType());
                    } else if (StringUtils.isNotEmpty((String)empInfo.getEmploymentTypeCode())) {
                        entityEmpInfo.setEmployeeType(EntityEmploymentTypeBo.from((CodedAttribute)this.getIdentityService().getEmploymentType(empInfo.getEmploymentTypeCode())));
                    }
                    entityEmpInfo.setActive(empInfo.isActive());
                    entityEmpInfo.setPrimary(empInfo.isPrimary());
                    entityEmpInfo.setEntityId(identityManagementPersonDocument.getEntityId());
                    entityEmpInfo.setEntityAffiliationId(empInfo.getEntityAffiliationId());
                    if (ObjectUtils.isNotNull(origEmpInfos)) {
                        for (EntityEmploymentBo origEmpInfo : origEmpInfos) {
                            if (this.isSameEmpInfo(origEmpInfo, entityEmpInfo)) {
                                entityEmpInfo.setId(origEmpInfo.getId());
                            }
                            if (origEmpInfo.getId() == null || !StringUtils.equals((String)origEmpInfo.getId(), (String)entityEmpInfo.getId())) continue;
                            entityEmpInfo.setVersionNumber(origEmpInfo.getVersionNumber());
                            entityEmpInfo.setEmploymentRecordId(empInfo.getEmploymentRecordId());
                        }
                    }
                    if (StringUtils.isEmpty((String)entityEmpInfo.getEmploymentRecordId())) {
                        entityEmpInfo.setEmploymentRecordId("" + ++employeeRecordCounter);
                    }
                    entityEmploymentInformations.add(entityEmpInfo);
                }
            }
        }
        kimEntity.setEmploymentInformation(entityEmploymentInformations);
        kimEntity.setAffiliations(entityAffiliations);
    }

    private boolean isBlankRoleQualifierVisible(String namespaceCode) {
        boolean showBlankQualifiers = true;
        Parameter param = this.getParameterService().getParameter(namespaceCode, "All", "KIM_SHOW_BLANK_QUALIFIERS");
        if (param != null) {
            showBlankQualifiers = "Y".equals(param.getValue());
        } else {
            String configProperty = ConfigContext.getCurrentContextConfig().getProperty(SHOW_BLANK_QUALIFIERS);
            if (configProperty != null) {
                showBlankQualifiers = Boolean.parseBoolean(configProperty);
            }
        }
        return showBlankQualifiers;
    }

    private boolean isSameAffiliation(EntityAffiliationBo origAffiliation, EntityAffiliationBo entityAffiliation) {
        return origAffiliation != null && entityAffiliation != null && StringUtils.isNotEmpty((String)origAffiliation.getCampusCode()) && StringUtils.equals((String)origAffiliation.getCampusCode(), (String)entityAffiliation.getCampusCode()) && StringUtils.isNotEmpty((String)origAffiliation.getAffiliationTypeCode()) && StringUtils.equals((String)origAffiliation.getAffiliationTypeCode(), (String)entityAffiliation.getAffiliationTypeCode()) && StringUtils.isNotEmpty((String)origAffiliation.getEntityId()) && StringUtils.equals((String)origAffiliation.getEntityId(), (String)entityAffiliation.getEntityId());
    }

    private boolean isSameEmpInfo(EntityEmploymentBo origEmpInfo, EntityEmploymentBo entityEmpInfo) {
        return origEmpInfo != null && entityEmpInfo != null && StringUtils.isNotEmpty((String)origEmpInfo.getEmploymentRecordId()) && StringUtils.equals((String)origEmpInfo.getEmploymentRecordId(), (String)entityEmpInfo.getEmploymentRecordId()) && StringUtils.equals((String)origEmpInfo.getEntityId(), (String)entityEmpInfo.getEntityId());
    }

    private void setupPhone(IdentityManagementPersonDocument identityManagementPersonDocument, EntityTypeContactInfoBo entityType, List<EntityPhoneBo> origPhones) {
        if (!identityManagementPersonDocument.getPrivacy().isSuppressPhone() || this.canOverrideEntityPrivacyPreferences(this.getInitiatorPrincipalId((Document)identityManagementPersonDocument), identityManagementPersonDocument.getPrincipalId())) {
            ArrayList<EntityPhoneBo> entityPhones = new ArrayList<EntityPhoneBo>();
            if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getPhones())) {
                for (PersonDocumentPhone phone : identityManagementPersonDocument.getPhones()) {
                    EntityPhoneBo entityPhone = new EntityPhoneBo();
                    entityPhone.setPhoneTypeCode(phone.getPhoneTypeCode());
                    if (phone.getPhoneType() != null) {
                        entityPhone.setPhoneType(phone.getPhoneType());
                    } else if (StringUtils.isNotEmpty((String)phone.getPhoneTypeCode())) {
                        entityPhone.setPhoneType(EntityPhoneTypeBo.from((CodedAttribute)this.getIdentityService().getAddressType(phone.getPhoneTypeCode())));
                    }
                    entityPhone.setEntityId(identityManagementPersonDocument.getEntityId());
                    entityPhone.setId(phone.getEntityPhoneId());
                    entityPhone.setEntityTypeCode(entityType.getEntityTypeCode());
                    entityPhone.setPhoneNumber(phone.getPhoneNumber());
                    entityPhone.setCountryCode(phone.getCountryCode());
                    entityPhone.setExtensionNumber(phone.getExtensionNumber());
                    entityPhone.setActive(phone.isActive());
                    entityPhone.setDefaultValue(phone.isDflt());
                    if (ObjectUtils.isNotNull(origPhones)) {
                        for (EntityPhoneContract entityPhoneContract : origPhones) {
                            if (entityPhoneContract.getId() == null || !StringUtils.equals((String)entityPhoneContract.getId(), (String)entityPhone.getId())) continue;
                            entityPhone.setVersionNumber(entityPhoneContract.getVersionNumber());
                        }
                    }
                    entityPhone.setId(phone.getEntityPhoneId());
                    entityPhones.add(entityPhone);
                }
            }
            entityType.setPhoneNumbers(entityPhones);
        }
    }

    private List<PersonDocumentPhone> loadPhones(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId, List<EntityPhone> entityPhones, boolean suppressDisplay) {
        ArrayList<PersonDocumentPhone> docPhones = new ArrayList<PersonDocumentPhone>();
        if (ObjectUtils.isNotNull(entityPhones)) {
            for (EntityPhone phone : entityPhones) {
                if (!phone.isActive()) continue;
                PersonDocumentPhone docPhone = new PersonDocumentPhone();
                if (phone.getPhoneType() != null) {
                    docPhone.setPhoneTypeCode(phone.getPhoneType().getCode());
                }
                docPhone.setEntityTypeCode(phone.getEntityTypeCode());
                docPhone.setPhoneNumber(phone.getPhoneNumberUnmasked());
                docPhone.setCountryCode(phone.getCountryCodeUnmasked());
                docPhone.setExtensionNumber(phone.getExtensionNumberUnmasked());
                docPhone.setActive(phone.isActive());
                docPhone.setDflt(phone.isDefaultValue());
                docPhone.setEntityPhoneId(phone.getId());
                docPhone.setEdit(true);
                docPhones.add(docPhone);
            }
        }
        return docPhones;
    }

    private void setupEmail(IdentityManagementPersonDocument identityManagementPersonDocument, EntityTypeContactInfoBo entityType, List<EntityEmailBo> origEmails) {
        if (!identityManagementPersonDocument.getPrivacy().isSuppressEmail() || this.canOverrideEntityPrivacyPreferences(this.getInitiatorPrincipalId((Document)identityManagementPersonDocument), identityManagementPersonDocument.getPrincipalId())) {
            ArrayList<EntityEmailBo> entityEmails = new ArrayList<EntityEmailBo>();
            if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getEmails())) {
                for (PersonDocumentEmail email : identityManagementPersonDocument.getEmails()) {
                    EntityEmailBo entityEmail = new EntityEmailBo();
                    entityEmail.setEntityId(identityManagementPersonDocument.getEntityId());
                    entityEmail.setEntityTypeCode(entityType.getEntityTypeCode());
                    if (email.getEmailType() != null) {
                        entityEmail.setEmailType(email.getEmailType());
                    } else if (StringUtils.isNotEmpty((String)email.getEmailTypeCode())) {
                        entityEmail.setEmailType(EntityEmailTypeBo.from((CodedAttribute)this.getIdentityService().getEmailType(email.getEmailTypeCode())));
                    }
                    entityEmail.setEmailTypeCode(email.getEmailTypeCode());
                    entityEmail.setEmailAddress(email.getEmailAddress());
                    entityEmail.setActive(email.isActive());
                    entityEmail.setDefaultValue(email.isDflt());
                    entityEmail.setId(email.getEntityEmailId());
                    if (ObjectUtils.isNotNull(origEmails)) {
                        for (EntityEmailContract entityEmailContract : origEmails) {
                            if (entityEmailContract.getId() == null || !StringUtils.equals((String)entityEmailContract.getId(), (String)entityEmail.getId())) continue;
                            entityEmail.setVersionNumber(entityEmailContract.getVersionNumber());
                        }
                    }
                    entityEmails.add(entityEmail);
                }
            }
            entityType.setEmailAddresses(entityEmails);
        }
    }

    private List<PersonDocumentEmail> loadEmails(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId, List<EntityEmail> entityEmails, boolean suppressDisplay) {
        ArrayList<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
        if (ObjectUtils.isNotNull(entityEmails)) {
            for (EntityEmail email : entityEmails) {
                if (!email.isActive()) continue;
                PersonDocumentEmail docEmail = new PersonDocumentEmail();
                docEmail.setEntityTypeCode(email.getEntityTypeCode());
                if (email.getEmailType() != null) {
                    docEmail.setEmailTypeCode(email.getEmailType().getCode());
                }
                docEmail.setEmailAddress(email.getEmailAddressUnmasked());
                docEmail.setActive(email.isActive());
                docEmail.setDflt(email.isDefaultValue());
                docEmail.setEntityEmailId(email.getId());
                docEmail.setEdit(true);
                emails.add(docEmail);
            }
        }
        return emails;
    }

    private void setupAddress(IdentityManagementPersonDocument identityManagementPersonDocument, EntityTypeContactInfoBo entityType, List<EntityAddressBo> origAddresses) {
        if (!identityManagementPersonDocument.getPrivacy().isSuppressAddress() || this.canOverrideEntityPrivacyPreferences(this.getInitiatorPrincipalId((Document)identityManagementPersonDocument), identityManagementPersonDocument.getPrincipalId())) {
            ArrayList<EntityAddressBo> entityAddresses = new ArrayList<EntityAddressBo>();
            if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getAddrs())) {
                for (PersonDocumentAddress address : identityManagementPersonDocument.getAddrs()) {
                    EntityAddressBo entityAddress = new EntityAddressBo();
                    entityAddress.setEntityId(identityManagementPersonDocument.getEntityId());
                    entityAddress.setEntityTypeCode(entityType.getEntityTypeCode());
                    entityAddress.setAddressTypeCode(address.getAddressTypeCode());
                    if (address.getAddressType() != null) {
                        entityAddress.setAddressType(address.getAddressType());
                    } else if (StringUtils.isNotEmpty((String)address.getAddressTypeCode())) {
                        entityAddress.setAddressType(EntityAddressTypeBo.from((CodedAttribute)this.getIdentityService().getAddressType(address.getAddressTypeCode())));
                    }
                    entityAddress.setLine1(address.getLine1());
                    entityAddress.setLine2(address.getLine2());
                    entityAddress.setLine3(address.getLine3());
                    entityAddress.setStateProvinceCode(address.getStateProvinceCode());
                    entityAddress.setPostalCode(address.getPostalCode());
                    entityAddress.setCountryCode(address.getCountryCode());
                    entityAddress.setCity(address.getCity());
                    entityAddress.setActive(address.isActive());
                    entityAddress.setDefaultValue(address.isDflt());
                    entityAddress.setId(address.getEntityAddressId());
                    if (ObjectUtils.isNotNull(origAddresses)) {
                        for (EntityAddressContract entityAddressContract : origAddresses) {
                            if (entityAddressContract.getId() == null || !StringUtils.equals((String)entityAddressContract.getId(), (String)entityAddress.getId())) continue;
                            entityAddress.setVersionNumber(entityAddressContract.getVersionNumber());
                        }
                    }
                    entityAddresses.add(entityAddress);
                }
            }
            entityType.setAddresses(entityAddresses);
        }
    }

    private List<PersonDocumentAddress> loadAddresses(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId, List<EntityAddress> entityAddresses, boolean suppressDisplay) {
        ArrayList<PersonDocumentAddress> docAddresses = new ArrayList<PersonDocumentAddress>();
        if (ObjectUtils.isNotNull(entityAddresses)) {
            for (EntityAddress address : entityAddresses) {
                if (!address.isActive()) continue;
                PersonDocumentAddress docAddress = new PersonDocumentAddress();
                docAddress.setEntityTypeCode(address.getEntityTypeCode());
                docAddress.setAddressTypeCode(address.getAddressType().getCode());
                docAddress.setLine1(address.getLine1Unmasked());
                docAddress.setLine2(address.getLine2Unmasked());
                docAddress.setLine3(address.getLine3Unmasked());
                docAddress.setStateProvinceCode(address.getStateProvinceCodeUnmasked());
                docAddress.setPostalCode(address.getPostalCodeUnmasked());
                docAddress.setCountryCode(address.getCountryCodeUnmasked());
                docAddress.setCity(address.getCityUnmasked());
                docAddress.setActive(address.isActive());
                docAddress.setDflt(address.isDefaultValue());
                docAddress.setEntityAddressId(address.getId());
                docAddress.setEdit(true);
                docAddresses.add(docAddress);
            }
        }
        return docAddresses;
    }

    private List<GroupMemberBo> populateGroupMembers(IdentityManagementPersonDocument identityManagementPersonDocument) {
        ArrayList<GroupMemberBo> groupPrincipals = new ArrayList<GroupMemberBo>();
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getGroups())) {
            for (PersonDocumentGroup group : identityManagementPersonDocument.getGroups()) {
                GroupMember.Builder groupPrincipalImpl = GroupMember.Builder.create((String)group.getGroupId(), (String)identityManagementPersonDocument.getPrincipalId(), (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
                if (group.getActiveFromDate() != null) {
                    groupPrincipalImpl.setActiveFromDate(new DateTime(group.getActiveFromDate().getTime()));
                }
                if (group.getActiveToDate() != null) {
                    groupPrincipalImpl.setActiveToDate(new DateTime(group.getActiveToDate().getTime()));
                }
                groupPrincipalImpl.setId(group.getGroupMemberId());
                List currGroupMembers = this.getGroupService().getMembers(Collections.singletonList(group.getGroupId()));
                if (ObjectUtils.isNotNull((Object)currGroupMembers)) {
                    for (GroupMember origGroupMember : currGroupMembers) {
                        if (!origGroupMember.isActive(new DateTime(System.currentTimeMillis())) || !KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)origGroupMember.getType()) || origGroupMember.getId() == null || !StringUtils.equals((String)origGroupMember.getId(), (String)group.getGroupMemberId())) continue;
                        groupPrincipalImpl.setObjectId(origGroupMember.getObjectId());
                        groupPrincipalImpl.setVersionNumber(origGroupMember.getVersionNumber());
                    }
                }
                groupPrincipals.add(GroupMemberBo.from((GroupMember)groupPrincipalImpl.build()));
            }
        }
        return groupPrincipals;
    }

    private List<RoleMemberBo> populateRoleMembers(IdentityManagementPersonDocument identityManagementPersonDocument) {
        List<RoleBo> origRoles = this.getRolesForPrincipal(identityManagementPersonDocument.getPrincipalId());
        ArrayList<RoleMemberBo> roleMembers = new ArrayList<RoleMemberBo>();
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getRoles())) {
            for (PersonDocumentRole role : identityManagementPersonDocument.getRoles()) {
                List origRoleMembers = new ArrayList();
                if (ObjectUtils.isNotNull(origRoles)) {
                    for (RoleBo origRole : origRoles) {
                        if (origRole.getId() == null || !StringUtils.equals((String)origRole.getId(), (String)role.getRoleId())) continue;
                        origRoleMembers = origRole.getMembers();
                        break;
                    }
                }
                if (role.getRolePrncpls().isEmpty()) {
                    if (role.getDefinitions().isEmpty()) continue;
                    RoleMemberBo roleMemberImpl = new RoleMemberBo();
                    roleMemberImpl.setRoleId(role.getRoleId());
                    roleMemberImpl.setMemberId(identityManagementPersonDocument.getPrincipalId());
                    roleMemberImpl.setType(MemberType.PRINCIPAL);
                    roleMembers.add(roleMemberImpl);
                    continue;
                }
                for (KimDocumentRoleMember roleMember : role.getRolePrncpls()) {
                    RoleMemberBo roleMemberImpl = new RoleMemberBo();
                    roleMemberImpl.setRoleId(role.getRoleId());
                    roleMemberImpl.setMemberId(identityManagementPersonDocument.getPrincipalId());
                    roleMemberImpl.setType(MemberType.PRINCIPAL);
                    roleMemberImpl.setId(roleMember.getRoleMemberId());
                    if (roleMember.getActiveFromDate() != null) {
                        roleMemberImpl.setActiveFromDateValue(new Timestamp(roleMember.getActiveFromDate().getTime()));
                    }
                    if (roleMember.getActiveToDate() != null) {
                        roleMemberImpl.setActiveToDateValue(new Timestamp(roleMember.getActiveToDate().getTime()));
                    }
                    List origAttributes = new ArrayList();
                    if (ObjectUtils.isNotNull(origRoleMembers)) {
                        for (RoleMemberBo origMember : origRoleMembers) {
                            if (origMember.getId() == null || !StringUtils.equals((String)origMember.getId(), (String)roleMember.getRoleMemberId())) continue;
                            origAttributes = origMember.getAttributeDetails();
                            roleMemberImpl.setVersionNumber(origMember.getVersionNumber());
                        }
                    }
                    ArrayList<RoleMemberAttributeDataBo> attributes = new ArrayList<RoleMemberAttributeDataBo>();
                    if (CollectionUtils.isNotEmpty(roleMember.getQualifiers())) {
                        for (KimDocumentRoleQualifier qualifier : roleMember.getQualifiers()) {
                            RoleMemberAttributeDataBo attribute = new RoleMemberAttributeDataBo();
                            attribute.setId(qualifier.getAttrDataId());
                            attribute.setAttributeValue(qualifier.getAttrVal());
                            attribute.setKimAttributeId(qualifier.getKimAttrDefnId());
                            attribute.setAssignedToId(qualifier.getRoleMemberId());
                            attribute.setKimTypeId(qualifier.getKimTypId());
                            this.updateAttrValIfNecessary(attribute);
                            if (ObjectUtils.isNotNull(origAttributes)) {
                                for (RoleMemberAttributeDataBo origAttribute : origAttributes) {
                                    if (origAttribute.getId() == null || !StringUtils.equals((String)origAttribute.getId(), (String)qualifier.getAttrDataId())) continue;
                                    attribute.setVersionNumber(origAttribute.getVersionNumber());
                                }
                            }
                            if (attribute.getVersionNumber() == null && !StringUtils.isNotBlank((String)qualifier.getAttrVal())) continue;
                            attributes.add(attribute);
                        }
                    }
                    roleMemberImpl.setAttributeDetails(attributes);
                    roleMembers.add(roleMemberImpl);
                }
            }
        }
        return roleMembers;
    }

    private List<DelegateTypeBo> populateDelegations(IdentityManagementPersonDocument identityManagementPersonDocument) {
        List<DelegateTypeBo> origDelegations = this.getPersonDelegations(identityManagementPersonDocument.getPrincipalId());
        ArrayList<DelegateTypeBo> kimDelegations = new ArrayList<DelegateTypeBo>();
        DelegateTypeBo origDelegationImplTemp = null;
        boolean activatingInactive = false;
        String newDelegationIdAssigned = "";
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getDelegations())) {
            for (RoleDocumentDelegation roleDocumentDelegation : identityManagementPersonDocument.getDelegations()) {
                DelegateTypeBo newKimDelegation = new DelegateTypeBo();
                KimCommonUtilsInternal.copyProperties(newKimDelegation, (Object)roleDocumentDelegation);
                newKimDelegation.setRoleId(roleDocumentDelegation.getRoleId());
                if (ObjectUtils.isNotNull(origDelegations)) {
                    for (DelegateTypeBo origDelegationImpl : origDelegations) {
                        if (origDelegationImpl.getRoleId() != null && StringUtils.equals((String)origDelegationImpl.getRoleId(), (String)newKimDelegation.getRoleId()) && origDelegationImpl.getDelegationId() != null && StringUtils.equals((String)origDelegationImpl.getDelegationId(), (String)newKimDelegation.getDelegationId())) {
                            newDelegationIdAssigned = newKimDelegation.getDelegationId();
                            newKimDelegation.setDelegationId(origDelegationImpl.getDelegationId());
                            activatingInactive = true;
                        }
                        if (origDelegationImpl.getDelegationId() == null || !StringUtils.equals((String)origDelegationImpl.getDelegationId(), (String)newKimDelegation.getDelegationId())) continue;
                        newKimDelegation.setVersionNumber(origDelegationImpl.getVersionNumber());
                        origDelegationImplTemp = origDelegationImpl;
                    }
                }
                ArrayList<DelegateMemberBo> origMembers = origDelegationImplTemp == null || origDelegationImplTemp.getMembers() == null ? new ArrayList() : origDelegationImplTemp.getMembers();
                newKimDelegation.setMembers(this.getDelegationMembers(roleDocumentDelegation.getMembers(), origMembers, null, activatingInactive, newDelegationIdAssigned));
                newKimDelegation.setVersionNumber(null);
                kimDelegations.add(newKimDelegation);
                activatingInactive = false;
            }
        }
        return kimDelegations;
    }

    private List<RoleMemberAttributeDataBo> getBlankRoleMemberAttrs(List<RoleMemberBo> rolePrncpls) {
        ArrayList<RoleMemberAttributeDataBo> blankRoleMemberAttrs = new ArrayList<RoleMemberAttributeDataBo>();
        if (ObjectUtils.isNotNull(rolePrncpls)) {
            for (RoleMemberBo roleMbr : rolePrncpls) {
                ArrayList<RoleMemberAttributeDataBo> roleMemberAttrs = new ArrayList<RoleMemberAttributeDataBo>();
                if (!CollectionUtils.isNotEmpty((Collection)roleMbr.getAttributeDetails())) continue;
                for (RoleMemberAttributeDataBo attr : roleMbr.getAttributeDetails()) {
                    if (!StringUtils.isBlank((String)attr.getAttributeValue())) continue;
                    roleMemberAttrs.add(attr);
                }
                if (roleMemberAttrs.isEmpty()) continue;
                roleMbr.getAttributeDetails().removeAll(roleMemberAttrs);
                blankRoleMemberAttrs.addAll(roleMemberAttrs);
            }
        }
        return blankRoleMemberAttrs;
    }

    private List<RoleResponsibilityActionBo> populateRoleRspActions(IdentityManagementPersonDocument identityManagementPersonDocument) {
        ArrayList<RoleResponsibilityActionBo> roleRspActions = new ArrayList<RoleResponsibilityActionBo>();
        if (CollectionUtils.isNotEmpty(identityManagementPersonDocument.getRoles())) {
            for (PersonDocumentRole role : identityManagementPersonDocument.getRoles()) {
                if (!CollectionUtils.isNotEmpty(role.getRolePrncpls())) continue;
                for (KimDocumentRoleMember roleMbr : role.getRolePrncpls()) {
                    if (!CollectionUtils.isNotEmpty(roleMbr.getRoleRspActions())) continue;
                    for (KimDocumentRoleResponsibilityAction roleRspAction : roleMbr.getRoleRspActions()) {
                        RoleResponsibilityActionBo entRoleRspAction = new RoleResponsibilityActionBo();
                        entRoleRspAction.setId(roleRspAction.getRoleResponsibilityActionId());
                        entRoleRspAction.setActionPolicyCode(roleRspAction.getActionPolicyCode());
                        entRoleRspAction.setActionTypeCode(roleRspAction.getActionTypeCode());
                        entRoleRspAction.setPriorityNumber(roleRspAction.getPriorityNumber());
                        entRoleRspAction.setRoleMemberId(roleRspAction.getRoleMemberId());
                        entRoleRspAction.setRoleResponsibilityId(roleRspAction.getRoleResponsibilityId());
                        List<RoleResponsibilityActionBo> actions = this.getRoleRspActions(roleMbr.getRoleMemberId());
                        if (ObjectUtils.isNotNull(actions)) {
                            for (RoleResponsibilityActionBo orgRspAction : actions) {
                                if (orgRspAction.getId() == null || !StringUtils.equals((String)orgRspAction.getId(), (String)roleRspAction.getRoleResponsibilityActionId())) continue;
                                entRoleRspAction.setVersionNumber(orgRspAction.getVersionNumber());
                            }
                        }
                        roleRspActions.add(entRoleRspAction);
                    }
                }
            }
        }
        return roleRspActions;
    }

    @Override
    public void loadRoleDoc(IdentityManagementRoleDocument identityManagementRoleDocument, Role role) {
        RoleBo roleBo = (RoleBo)this.getDataObjectService().find(RoleBo.class, (Object)role.getId());
        identityManagementRoleDocument.setRoleId(roleBo.getId());
        identityManagementRoleDocument.setKimType(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType()));
        identityManagementRoleDocument.setRoleTypeName(roleBo.getKimRoleType().getName());
        identityManagementRoleDocument.setRoleTypeId(roleBo.getKimTypeId());
        identityManagementRoleDocument.setRoleName(roleBo.getName());
        identityManagementRoleDocument.setRoleDescription(roleBo.getDescription());
        identityManagementRoleDocument.setActive(roleBo.isActive());
        identityManagementRoleDocument.setRoleNamespace(roleBo.getNamespaceCode());
        identityManagementRoleDocument.setEditing(true);
        identityManagementRoleDocument.setPermissions(this.loadPermissions(this.getDataObjectService().findMatching(RolePermissionBo.class, QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)role.getId()).build()).getResults()));
        identityManagementRoleDocument.setResponsibilities(this.loadResponsibilities(this.getDataObjectService().findMatching(RoleResponsibilityBo.class, QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)role.getId()).build()).getResults()));
        this.loadResponsibilityRoleRspActions(identityManagementRoleDocument);
        identityManagementRoleDocument.setMembers(this.loadRoleMembers(identityManagementRoleDocument, roleBo.getMembers()));
        this.loadMemberRoleRspActions(identityManagementRoleDocument);
        identityManagementRoleDocument.setDelegations(this.loadRoleDocumentDelegations(identityManagementRoleDocument, this.getRoleDelegations(roleBo.getId())));
        this.setDelegationMembersInDocument(identityManagementRoleDocument);
        identityManagementRoleDocument.setKimType(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType()));
    }

    @Override
    public void loadRoleMembersBasedOnSearch(IdentityManagementRoleDocument identityManagementRoleDocument, String memberSearchValue) {
        ArrayList<KimDocumentRoleMember> roleMembersRestricted = new ArrayList<KimDocumentRoleMember>();
        List<KimDocumentRoleMember> members = identityManagementRoleDocument.getMembers();
        for (KimDocumentRoleMember roleMember : members) {
            String memberName = roleMember.getMemberName().toLowerCase();
            if (!memberName.startsWith(memberSearchValue.toLowerCase())) continue;
            roleMembersRestricted.add(roleMember);
        }
        identityManagementRoleDocument.setSearchResultMembers(roleMembersRestricted);
    }

    @Override
    public void clearRestrictedRoleMembersSearchResults(IdentityManagementRoleDocument identityManagementRoleDocument) {
        ArrayList<KimDocumentRoleMember> roleMembersRestricted = new ArrayList<KimDocumentRoleMember>();
        List<KimDocumentRoleMember> members = identityManagementRoleDocument.getMembers();
        identityManagementRoleDocument.setSearchResultMembers(roleMembersRestricted);
        identityManagementRoleDocument.setMembers(members);
    }

    @Override
    public void setDelegationMembersInDocument(IdentityManagementRoleDocument identityManagementRoleDocument) {
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getDelegations())) {
            for (RoleDocumentDelegation delegation : identityManagementRoleDocument.getDelegations()) {
                if (!CollectionUtils.isNotEmpty(delegation.getMembers())) continue;
                for (RoleDocumentDelegationMember member : delegation.getMembers()) {
                    RoleMemberBo roleMember;
                    member.setDelegationTypeCode(delegation.getDelegationTypeCode());
                    if (StringUtils.isEmpty((String)member.getRoleMemberName()) && (roleMember = this.getRoleMemberForRoleMemberId(member.getRoleMemberId())) != null) {
                        member.setRoleMemberName(this.getMemberName(roleMember.getType(), roleMember.getMemberId()));
                        member.setRoleMemberNamespaceCode(this.getMemberNamespaceCode(roleMember.getType(), roleMember.getMemberId()));
                    }
                    member.setEdit(true);
                    identityManagementRoleDocument.getDelegationMembers().add(member);
                }
            }
        }
    }

    private List<KimDocumentRoleResponsibility> loadResponsibilities(List<RoleResponsibilityBo> roleResponsibilities) {
        ArrayList<KimDocumentRoleResponsibility> documentRoleResponsibilities = new ArrayList<KimDocumentRoleResponsibility>();
        if (ObjectUtils.isNotNull(roleResponsibilities)) {
            for (RoleResponsibilityBo roleResponsibility : roleResponsibilities) {
                if (!roleResponsibility.isActive()) continue;
                KimDocumentRoleResponsibility roleResponsibilityCopy = new KimDocumentRoleResponsibility();
                KimCommonUtilsInternal.copyProperties((Object)roleResponsibilityCopy, roleResponsibility);
                roleResponsibilityCopy.setEdit(true);
                documentRoleResponsibilities.add(roleResponsibilityCopy);
            }
        }
        return documentRoleResponsibilities;
    }

    private List<KimDocumentRolePermission> loadPermissions(List<RolePermissionBo> rolePermissions) {
        ArrayList<KimDocumentRolePermission> documentRolePermissions = new ArrayList<KimDocumentRolePermission>();
        if (ObjectUtils.isNotNull(rolePermissions)) {
            for (RolePermissionBo rolePermission : rolePermissions) {
                if (!rolePermission.isActive()) continue;
                KimDocumentRolePermission rolePermissionCopy = new KimDocumentRolePermission();
                rolePermissionCopy.setRolePermissionId(rolePermission.getId());
                rolePermissionCopy.setRoleId(rolePermission.getRoleId());
                rolePermissionCopy.setPermissionId(rolePermission.getPermissionId());
                rolePermissionCopy.setPermission(PermissionBo.to((PermissionBo)rolePermission.getPermission()));
                rolePermissionCopy.setEdit(true);
                documentRolePermissions.add(rolePermissionCopy);
            }
        }
        return documentRolePermissions;
    }

    @Override
    public void setMembersInDocument(IdentityManagementRoleDocument identityManagementRoleDocument) {
        ArrayList<Object> members;
        if (StringUtils.isNotBlank((String)identityManagementRoleDocument.getRoleId())) {
            RoleBo roleBo = (RoleBo)this.getDataObjectService().find(RoleBo.class, (Object)identityManagementRoleDocument.getRoleId());
            if (roleBo != null) {
                members = new ArrayList(roleBo.getMembers());
                ArrayList<RoleMemberBo> membersToRemove = new ArrayList<RoleMemberBo>();
                boolean found = false;
                block0: for (KimDocumentRoleMember modifiedMember : identityManagementRoleDocument.getModifiedMembers()) {
                    for (RoleMemberBo roleMemberBo : members) {
                        if (modifiedMember.getRoleMemberId().equals(roleMemberBo.getId())) {
                            membersToRemove.add(roleMemberBo);
                            found = true;
                        }
                        if (!found) continue;
                        continue block0;
                    }
                }
                members.removeAll(membersToRemove);
            } else {
                members = new ArrayList();
            }
        } else {
            members = new ArrayList<RoleMemberBo>();
        }
        identityManagementRoleDocument.setMembers(this.loadRoleMembers(identityManagementRoleDocument, members));
        this.loadMemberRoleRspActions(identityManagementRoleDocument);
    }

    private Map<String, Group> findGroupsForRole(String roleId) {
        HashMap<String, Group> roleGroupMembers = new HashMap<String, Group>();
        List groupRoleMembers = this.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleId", (Object)roleId), PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode())})).getResults();
        ArrayList<String> groupIds = new ArrayList<String>(groupRoleMembers.size());
        for (RoleMember rm : groupRoleMembers) {
            groupIds.add(rm.getMemberId());
        }
        List groups = this.getGroupService().getGroups(groupIds);
        for (Group g : groups) {
            roleGroupMembers.put(g.getId(), g);
        }
        return roleGroupMembers;
    }

    private List<KimDocumentRoleMember> loadRoleMembers(IdentityManagementRoleDocument identityManagementRoleDocument, List<RoleMemberBo> members) {
        ArrayList<KimDocumentRoleMember> pndMembers = new ArrayList<KimDocumentRoleMember>();
        if (KRADUtils.isNull(members) || members.isEmpty()) {
            return pndMembers;
        }
        ArrayList<String> roleMemberPrincipalIds = new ArrayList<String>();
        for (RoleMemberBo roleMember : members) {
            if (!roleMember.getType().getCode().equals(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()) || roleMemberPrincipalIds.contains(roleMember.getMemberId())) continue;
            roleMemberPrincipalIds.add(roleMember.getMemberId());
        }
        HashMap<String, EntityDefault> principalIdToEntityMap = new HashMap<String, EntityDefault>();
        if (!roleMemberPrincipalIds.isEmpty()) {
            List principals = this.getIdentityService().findEntityDefaults(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.in((String)"principals.principalId", roleMemberPrincipalIds), PredicateFactory.equal((String)"principals.active", (Object)Boolean.TRUE), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)})).getResults();
            principalIdToEntityMap = new HashMap(principals.size());
            for (EntityDefault entity : principals) {
                principalIdToEntityMap.put(((Principal)entity.getPrincipals().get(0)).getPrincipalId(), entity);
            }
        }
        Map<String, Group> roleGroupMembers = this.findGroupsForRole(identityManagementRoleDocument.getRoleId());
        for (RoleMemberBo member : members) {
            KimDocumentRoleMember pndMember = new KimDocumentRoleMember();
            pndMember.setActiveFromDate(member.getActiveFromDateValue());
            pndMember.setActiveToDate(member.getActiveToDateValue());
            pndMember.setActive(member.isActive(this.getDateTimeService().getCurrentTimestamp()));
            if (!pndMember.isActive()) continue;
            pndMember.setRoleMemberId(member.getId());
            pndMember.setRoleId(member.getRoleId());
            pndMember.setMemberTypeCode(member.getType().getCode());
            pndMember.setMemberId(member.getMemberId());
            pndMember.setMemberNamespaceCode(this.getMemberNamespaceCode(member.getType(), member.getMemberId()));
            if (StringUtils.equals((String)pndMember.getMemberTypeCode(), (String)MemberType.PRINCIPAL.getCode())) {
                EntityDefault entity = (EntityDefault)principalIdToEntityMap.get(member.getMemberId());
                if (entity != null) {
                    pndMember.setMemberName(((Principal)entity.getPrincipals().get(0)).getPrincipalName());
                    if (entity.getName() != null) {
                        pndMember.setMemberFullName(entity.getName().getFirstName() + " " + entity.getName().getLastName());
                    }
                }
            } else if (StringUtils.equals((String)pndMember.getMemberTypeCode(), (String)MemberType.GROUP.getCode())) {
                Group group = roleGroupMembers.get(member.getMemberId());
                if (group != null) {
                    pndMember.setMemberName(group.getName());
                    pndMember.setMemberNamespaceCode(group.getNamespaceCode());
                    pndMember.setMemberFullName(group.getName());
                }
            } else if (StringUtils.equals((String)pndMember.getMemberTypeCode(), (String)MemberType.ROLE.getCode())) {
                pndMember.setMemberName(this.getMemberName(member.getType(), member.getMemberId()));
                pndMember.setMemberFullName(this.getMemberFullName(member.getType(), member.getMemberId()));
            }
            pndMember.setQualifiers(this.loadRoleMemberQualifiers(identityManagementRoleDocument, member.getAttributeDetails()));
            pndMember.setEdit(true);
            pndMembers.add(pndMember);
        }
        pndMembers.sort(identityManagementRoleDocument.getMemberMetaDataType());
        return pndMembers;
    }

    private void loadResponsibilityRoleRspActions(IdentityManagementRoleDocument identityManagementRoleDocument) {
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getResponsibilities())) {
            for (KimDocumentRoleResponsibility responsibility : identityManagementRoleDocument.getResponsibilities()) {
                responsibility.getRoleRspActions().addAll(this.loadKimDocumentRoleRespActions(this.getRoleResponsibilityActionImpls(responsibility.getRoleResponsibilityId())));
            }
        }
    }

    private RoleResponsibilityActionBo getRoleResponsibilityActionImpl(String roleResponsibilityActionId) {
        return (RoleResponsibilityActionBo)this.getDataObjectService().find(RoleResponsibilityActionBo.class, (Object)roleResponsibilityActionId);
    }

    private List<RoleResponsibilityActionBo> getRoleResponsibilityActionImpls(String roleResponsibilityId) {
        return this.getDataObjectService().findMatching(RoleResponsibilityActionBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleMemberId", (Object)"*"), PredicateFactory.equal((String)"roleResponsibilityId", (Object)roleResponsibilityId)})).getResults();
    }

    @Override
    public List<RoleResponsibilityActionBo> getRoleMemberResponsibilityActionImpls(String roleMemberId) {
        return this.getDataObjectService().findMatching(RoleResponsibilityActionBo.class, QueryByCriteria.Builder.forAttribute((String)"roleMemberId", (Object)roleMemberId).build()).getResults();
    }

    private void loadMemberRoleRspActions(IdentityManagementRoleDocument identityManagementRoleDocument) {
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getMembers())) {
            for (KimDocumentRoleMember member : identityManagementRoleDocument.getMembers()) {
                member.getRoleRspActions().addAll(this.loadKimDocumentRoleRespActions(this.getRoleMemberResponsibilityActionImpls(member.getRoleMemberId())));
            }
        }
    }

    private List<KimDocumentRoleResponsibilityAction> loadKimDocumentRoleRespActions(List<RoleResponsibilityActionBo> roleRespActionImpls) {
        ArrayList<KimDocumentRoleResponsibilityAction> documentRoleRespActions = new ArrayList<KimDocumentRoleResponsibilityAction>();
        if (ObjectUtils.isNotNull(roleRespActionImpls)) {
            for (RoleResponsibilityActionBo roleRespActionImpl : roleRespActionImpls) {
                KimDocumentRoleResponsibilityAction documentRoleRespAction = new KimDocumentRoleResponsibilityAction();
                KimCommonUtilsInternal.copyProperties((Object)documentRoleRespAction, roleRespActionImpl);
                documentRoleRespAction.setRoleResponsibilityActionId(roleRespActionImpl.getId());
                if (ObjectUtils.isNotNull((Object)roleRespActionImpl.getRoleResponsibility())) {
                    documentRoleRespAction.setKimResponsibility(roleRespActionImpl.getRoleResponsibility().getKimResponsibility());
                }
                documentRoleRespActions.add(documentRoleRespAction);
            }
        }
        return documentRoleRespActions;
    }

    @Override
    public Object getMember(MemberType memberType, String memberId) {
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            return this.getIdentityService().getPrincipal(memberId);
        }
        if (MemberType.GROUP.equals((Object)memberType)) {
            return this.getGroupService().getGroup(memberId);
        }
        if (MemberType.ROLE.equals((Object)memberType)) {
            return this.getRoleService().getRole(memberId);
        }
        return null;
    }

    @Override
    public String getMemberName(MemberType memberType, String memberId) {
        if (memberType == null || StringUtils.isEmpty((String)memberId)) {
            return "";
        }
        Object member = this.getMember(memberType, memberId);
        if (member == null) {
            return "";
        }
        return this.getMemberName(memberType, member);
    }

    private String getMemberFullName(MemberType memberType, String memberId) {
        Role role;
        if (memberType == null || StringUtils.isEmpty((String)memberId)) {
            return "";
        }
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            EntityDefault principalInfo = this.getIdentityService().getEntityDefaultByPrincipalId(memberId);
            if (principalInfo != null && principalInfo.getName() != null) {
                return principalInfo.getName().getFirstName() + " " + principalInfo.getName().getLastName();
            }
        } else if (MemberType.GROUP.equals((Object)memberType)) {
            Group group = (Group)this.getMember(memberType, memberId);
            if (group != null) {
                return group.getName();
            }
        } else if (MemberType.ROLE.equals((Object)memberType) && (role = (Role)this.getMember(memberType, memberId)) != null) {
            return role.getName();
        }
        return "";
    }

    @Override
    public String getMemberNamespaceCode(MemberType memberType, String memberId) {
        if (memberType == null || StringUtils.isEmpty((String)memberId)) {
            return "";
        }
        Object member = this.getMember(memberType, memberId);
        if (member == null) {
            return "";
        }
        if (MemberType.GROUP.equals((Object)memberType)) {
            return ((GroupContract)member).getNamespaceCode();
        }
        if (MemberType.ROLE.equals((Object)memberType)) {
            return ((RoleContract)member).getNamespaceCode();
        }
        return "";
    }

    @Override
    public String getMemberIdByName(MemberType memberType, String memberNamespaceCode, String memberName) {
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            Principal principal = this.getIdentityService().getPrincipalByPrincipalName(memberName);
            if (principal != null) {
                return principal.getPrincipalId();
            }
        } else if (MemberType.GROUP.equals((Object)memberType)) {
            Group groupInfo = this.getGroupService().getGroupByNamespaceCodeAndName(memberNamespaceCode, memberName);
            if (groupInfo != null) {
                return groupInfo.getId();
            }
        } else if (MemberType.ROLE.equals((Object)memberType)) {
            return this.getRoleService().getRoleIdByNamespaceCodeAndName(memberNamespaceCode, memberName);
        }
        return "";
    }

    @Override
    public String getMemberName(MemberType memberType, Object member) {
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            return ((PrincipalContract)member).getPrincipalName();
        }
        if (MemberType.GROUP.equals((Object)memberType)) {
            return ((GroupContract)member).getName();
        }
        if (MemberType.ROLE.equals((Object)memberType)) {
            return ((RoleContract)member).getName();
        }
        return "";
    }

    @Override
    public String getMemberNamespaceCode(MemberType memberType, Object member) {
        if (MemberType.GROUP.equals((Object)memberType)) {
            return ((GroupContract)member).getNamespaceCode();
        }
        if (MemberType.ROLE.equals((Object)memberType)) {
            return ((RoleContract)member).getNamespaceCode();
        }
        return "";
    }

    private List<KimDocumentRoleQualifier> loadRoleMemberQualifiers(IdentityManagementRoleDocument identityManagementRoleDocument, List<RoleMemberAttributeDataBo> attributeDataList) {
        KimDocumentRoleQualifier pndMemberRoleQualifier;
        ArrayList<KimDocumentRoleQualifier> pndMemberRoleQualifiers = new ArrayList<KimDocumentRoleQualifier>();
        if (attributeDataList != null) {
            for (RoleMemberAttributeDataBo memberRoleQualifier : attributeDataList) {
                pndMemberRoleQualifier = new KimDocumentRoleQualifier();
                pndMemberRoleQualifier.setAttrDataId(memberRoleQualifier.getId());
                pndMemberRoleQualifier.setAttrVal(memberRoleQualifier.getAttributeValue());
                pndMemberRoleQualifier.setRoleMemberId(memberRoleQualifier.getAssignedToId());
                pndMemberRoleQualifier.setKimTypId(memberRoleQualifier.getKimTypeId());
                pndMemberRoleQualifier.setKimAttrDefnId(memberRoleQualifier.getKimAttributeId());
                pndMemberRoleQualifier.setKimAttribute(memberRoleQualifier.getKimAttribute());
                this.formatAttrValIfNecessary(pndMemberRoleQualifier);
                pndMemberRoleQualifiers.add(pndMemberRoleQualifier);
            }
        }
        int countOfOriginalAttributesNotPresent = 0;
        ArrayList<KimDocumentRoleQualifier> fillerRoleQualifiers = new ArrayList<KimDocumentRoleQualifier>();
        List<KimAttributeField> origAttributes = identityManagementRoleDocument.getDefinitions();
        if (origAttributes != null) {
            for (KimAttributeField key : origAttributes) {
                boolean attributePresent = false;
                String origAttributeId = identityManagementRoleDocument.getKimAttributeDefnId(key);
                if (attributeDataList != null) {
                    for (RoleMemberAttributeDataBo memberRoleQualifier : attributeDataList) {
                        if (origAttributeId == null || !StringUtils.equals((String)origAttributeId, (String)memberRoleQualifier.getKimAttribute().getId())) continue;
                        attributePresent = true;
                        break;
                    }
                }
                if (attributePresent) continue;
                ++countOfOriginalAttributesNotPresent;
                pndMemberRoleQualifier = new KimDocumentRoleQualifier();
                pndMemberRoleQualifier.setKimAttrDefnId(origAttributeId);
                this.getDataObjectService().wrap((Object)pndMemberRoleQualifier).fetchRelationship(KIM_ATTRIBUTE);
                fillerRoleQualifiers.add(pndMemberRoleQualifier);
            }
            if (countOfOriginalAttributesNotPresent != origAttributes.size()) {
                pndMemberRoleQualifiers.addAll(fillerRoleQualifiers);
            }
        }
        return pndMemberRoleQualifiers;
    }

    @Override
    public List<DelegateTypeBo> getRoleDelegations(String roleId) {
        if (roleId == null) {
            return new ArrayList<DelegateTypeBo>();
        }
        return this.getDataObjectService().findMatching(DelegateTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)roleId).build()).getResults();
    }

    private List<RoleDocumentDelegation> loadRoleDocumentDelegations(IdentityManagementRoleDocument identityManagementRoleDocument, List<DelegateTypeBo> delegations) {
        ArrayList<RoleDocumentDelegation> delList = new ArrayList<RoleDocumentDelegation>();
        if (ObjectUtils.isNotNull(delegations)) {
            for (DelegateTypeBo del : delegations) {
                RoleDocumentDelegation documentDelegation = new RoleDocumentDelegation();
                documentDelegation.setActive(del.isActive());
                if (!documentDelegation.isActive()) continue;
                documentDelegation.setDelegationId(del.getDelegationId());
                documentDelegation.setDelegationTypeCode(del.getDelegationTypeCode());
                documentDelegation.setKimTypeId(del.getKimTypeId());
                documentDelegation.setMembers(this.loadDelegationMembers(identityManagementRoleDocument, del.getMembers()));
                documentDelegation.setRoleId(del.getRoleId());
                documentDelegation.setEdit(true);
                delList.add(documentDelegation);
            }
        }
        return delList;
    }

    private List<RoleDocumentDelegationMember> loadDelegationMembers(IdentityManagementRoleDocument identityManagementRoleDocument, List<DelegateMemberBo> members) {
        ArrayList<RoleDocumentDelegationMember> pndMembers = new ArrayList<RoleDocumentDelegationMember>();
        if (ObjectUtils.isNotNull(members)) {
            for (DelegateMemberBo member : members) {
                RoleDocumentDelegationMember pndMember = new RoleDocumentDelegationMember();
                pndMember.setActiveFromDate(member.getActiveFromDateValue());
                pndMember.setActiveToDate(member.getActiveToDateValue());
                pndMember.setActive(member.isActive(this.getDateTimeService().getCurrentTimestamp()));
                if (!pndMember.isActive()) continue;
                pndMember.setDelegationId(member.getDelegationId());
                pndMember.setDelegationMemberId(member.getDelegationMemberId());
                pndMember.setDelegationTypeCode(member.getType().getCode());
                pndMember.setRoleMemberId(member.getRoleMemberId());
                pndMember.setMemberId(member.getMemberId());
                pndMember.setMemberTypeCode(member.getType().getCode());
                RoleMemberBo roleMember = this.getRoleMemberForRoleMemberId(member.getRoleMemberId());
                if (roleMember != null) {
                    pndMember.setRoleMemberName(this.getMemberName(roleMember.getType(), roleMember.getMemberId()));
                    pndMember.setRoleMemberNamespaceCode(this.getMemberNamespaceCode(roleMember.getType(), roleMember.getMemberId()));
                }
                pndMember.setMemberNamespaceCode(this.getMemberNamespaceCode(member.getType(), member.getMemberId()));
                pndMember.setMemberName(this.getMemberName(member.getType(), member.getMemberId()));
                pndMember.setEdit(true);
                pndMember.setQualifiers(this.loadDelegationMemberQualifiers(identityManagementRoleDocument, member.getAttributeDetails()));
                pndMembers.add(pndMember);
            }
        }
        return pndMembers;
    }

    private RoleMemberBo getRoleMemberForRoleMemberId(String roleMemberId) {
        return (RoleMemberBo)this.getDataObjectService().find(RoleMemberBo.class, (Object)roleMemberId);
    }

    private List<RoleDocumentDelegationMemberQualifier> loadDelegationMemberQualifiers(IdentityManagementRoleDocument identityManagementRoleDocument, List<DelegateMemberAttributeDataBo> attributeDataList) {
        ArrayList<RoleDocumentDelegationMemberQualifier> pndMemberRoleQualifiers = new ArrayList<RoleDocumentDelegationMemberQualifier>();
        List<KimAttributeField> origAttributes = identityManagementRoleDocument.getDefinitions();
        boolean attributePresent = false;
        if (origAttributes != null) {
            for (KimAttributeField key : origAttributes) {
                RoleDocumentDelegationMemberQualifier pndMemberRoleQualifier;
                String origAttributeId = identityManagementRoleDocument.getKimAttributeDefnId(key);
                if (attributeDataList != null) {
                    for (DelegateMemberAttributeDataBo memberRoleQualifier : attributeDataList) {
                        if (origAttributeId == null || !StringUtils.equals((String)origAttributeId, (String)memberRoleQualifier.getKimAttribute().getId())) continue;
                        pndMemberRoleQualifier = new RoleDocumentDelegationMemberQualifier();
                        pndMemberRoleQualifier.setAttrDataId(memberRoleQualifier.getId());
                        pndMemberRoleQualifier.setAttrVal(memberRoleQualifier.getAttributeValue());
                        pndMemberRoleQualifier.setDelegationMemberId(memberRoleQualifier.getAssignedToId());
                        pndMemberRoleQualifier.setKimTypId(memberRoleQualifier.getKimTypeId());
                        pndMemberRoleQualifier.setKimAttrDefnId(memberRoleQualifier.getKimAttributeId());
                        pndMemberRoleQualifier.setKimAttribute(memberRoleQualifier.getKimAttribute());
                        pndMemberRoleQualifiers.add(pndMemberRoleQualifier);
                        attributePresent = true;
                    }
                }
                if (!attributePresent) {
                    pndMemberRoleQualifier = new RoleDocumentDelegationMemberQualifier();
                    pndMemberRoleQualifier.setKimAttrDefnId(origAttributeId);
                    this.getDataObjectService().wrap((Object)pndMemberRoleQualifier).fetchRelationship(KIM_ATTRIBUTE);
                    pndMemberRoleQualifiers.add(pndMemberRoleQualifier);
                }
                attributePresent = false;
            }
        }
        return pndMemberRoleQualifiers;
    }

    @Override
    public void saveRole(IdentityManagementRoleDocument identityManagementRoleDocument) {
        String initiatorPrincipalId;
        String roleId = identityManagementRoleDocument.getRoleId();
        RoleBo roleBo = (RoleBo)this.getDataObjectService().find(RoleBo.class, (Object)roleId);
        if (roleBo == null) {
            identityManagementRoleDocument.setActive(true);
            roleBo = new RoleBo();
            roleBo.setId(roleId);
            roleBo.setKimTypeId(identityManagementRoleDocument.getRoleTypeId());
            roleBo.setNamespaceCode(identityManagementRoleDocument.getRoleNamespace());
            roleBo.setName(identityManagementRoleDocument.getRoleName());
            roleBo.setDescription(identityManagementRoleDocument.getRoleDescription());
            roleBo.setActive(identityManagementRoleDocument.isActive());
            roleBo = (RoleBo)this.getDataObjectService().save((Object)roleBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        } else {
            roleBo.setName(identityManagementRoleDocument.getRoleName());
            roleBo.setDescription(identityManagementRoleDocument.getRoleDescription());
            roleBo.setActive(identityManagementRoleDocument.isActive());
        }
        QueryByCriteria altCriteria = QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)roleId).build();
        ArrayList<RolePermissionBo> origRolePermissions = new ArrayList<RolePermissionBo>(this.getDataObjectService().findMatching(RolePermissionBo.class, altCriteria).getResults());
        List origRoleResponsibilities = this.getDataObjectService().findMatching(RoleResponsibilityBo.class, altCriteria).getResults();
        List origRoleDelegations = this.getDataObjectService().findMatching(DelegateTypeBo.class, altCriteria).getResults();
        ArrayList<Object> objectsToSave = new ArrayList<Object>();
        objectsToSave.addAll(this.getRolePermissions(identityManagementRoleDocument, origRolePermissions));
        objectsToSave.addAll(this.getRoleResponsibilities(identityManagementRoleDocument, origRoleResponsibilities));
        objectsToSave.addAll(this.getRoleResponsibilitiesActions(identityManagementRoleDocument));
        objectsToSave.add(roleBo);
        if (this.getKimTypeInfoService().getKimType(identityManagementRoleDocument.getRoleTypeId()) == null) {
            LOG.error("Kim type not found for:" + identityManagementRoleDocument.getRoleTypeId(), new Throwable());
        }
        if (this.canAssignToRole(identityManagementRoleDocument, initiatorPrincipalId = this.getInitiatorPrincipalId((Document)identityManagementRoleDocument))) {
            List<RoleMemberBo> roleMembers = this.getRoleMembers(identityManagementRoleDocument, roleBo.getMembers());
            if (CollectionUtils.isNotEmpty(roleMembers)) {
                List members = roleMembers.stream().map(rm -> {
                    rm.setRoleId(roleId);
                    return rm;
                }).map(o -> (RoleMemberBo)this.getDataObjectService().save(o, new PersistenceOption[]{PersistenceOption.FLUSH})).collect(Collectors.toList());
                roleBo.setMembers(members);
            }
            objectsToSave.addAll(this.getRoleMemberResponsibilityActions(roleBo.getMembers()));
            objectsToSave.addAll(this.getRoleDelegations(identityManagementRoleDocument, origRoleDelegations));
        }
        objectsToSave.forEach(o -> this.getDataObjectService().save(o, new PersistenceOption[]{PersistenceOption.FLUSH}));
        this.getResponsibilityInternalService().updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(identityManagementRoleDocument, origRoleResponsibilities));
        if (!roleBo.isActive()) {
            this.getRoleInternalService().roleInactivated(identityManagementRoleDocument.getRoleId());
        }
    }

    private List<RolePermissionBo> getRolePermissions(IdentityManagementRoleDocument identityManagementRoleDocument, List<RolePermissionBo> origRolePermissions) {
        ArrayList<RolePermissionBo> rolePermissions = new ArrayList<RolePermissionBo>();
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getPermissions())) {
            for (KimDocumentRolePermission documentRolePermission : identityManagementRoleDocument.getPermissions()) {
                RolePermissionBo newRolePermission = new RolePermissionBo();
                newRolePermission.setId(documentRolePermission.getRolePermissionId());
                newRolePermission.setRoleId(identityManagementRoleDocument.getRoleId());
                newRolePermission.setPermissionId(documentRolePermission.getPermissionId());
                newRolePermission.setActive(documentRolePermission.isActive());
                newRolePermission.setActive(documentRolePermission.isActive());
                if (ObjectUtils.isNotNull(origRolePermissions)) {
                    for (RolePermissionBo origPermissionImpl : origRolePermissions) {
                        if (!StringUtils.equals((String)origPermissionImpl.getRoleId(), (String)newRolePermission.getRoleId()) && StringUtils.equals((String)origPermissionImpl.getPermissionId(), (String)newRolePermission.getPermissionId()) && origPermissionImpl.isActive() && newRolePermission.isActive()) {
                            newRolePermission.setId(origPermissionImpl.getId());
                        }
                        if (origPermissionImpl.getId() == null || !StringUtils.equals((String)origPermissionImpl.getId(), (String)newRolePermission.getId())) continue;
                        newRolePermission.setVersionNumber(origPermissionImpl.getVersionNumber());
                        newRolePermission.setObjectId(origPermissionImpl.getObjectId());
                    }
                }
                rolePermissions.add(newRolePermission);
            }
        }
        return rolePermissions;
    }

    private List<RoleResponsibilityBo> getRoleResponsibilities(IdentityManagementRoleDocument identityManagementRoleDocument, List<RoleResponsibilityBo> origRoleResponsibilities) {
        ArrayList<RoleResponsibilityBo> roleResponsibilities = new ArrayList<RoleResponsibilityBo>();
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getResponsibilities())) {
            for (KimDocumentRoleResponsibility documentRoleResponsibility : identityManagementRoleDocument.getResponsibilities()) {
                RoleResponsibilityBo newRoleResponsibility = new RoleResponsibilityBo();
                KimCommonUtilsInternal.copyProperties(newRoleResponsibility, (Object)documentRoleResponsibility);
                newRoleResponsibility.setActive(documentRoleResponsibility.isActive());
                newRoleResponsibility.setRoleId(identityManagementRoleDocument.getRoleId());
                newRoleResponsibility.setVersionNumber(null);
                if (ObjectUtils.isNotNull(origRoleResponsibilities)) {
                    for (RoleResponsibilityBo origResponsibilityImpl : origRoleResponsibilities) {
                        if (!StringUtils.equals((String)origResponsibilityImpl.getRoleId(), (String)newRoleResponsibility.getRoleId()) && StringUtils.equals((String)origResponsibilityImpl.getResponsibilityId(), (String)newRoleResponsibility.getResponsibilityId()) && !origResponsibilityImpl.isActive() && newRoleResponsibility.isActive()) {
                            newRoleResponsibility.setRoleResponsibilityId(origResponsibilityImpl.getRoleResponsibilityId());
                        }
                        if (origResponsibilityImpl.getRoleResponsibilityId() == null || !StringUtils.equals((String)origResponsibilityImpl.getRoleResponsibilityId(), (String)newRoleResponsibility.getRoleResponsibilityId())) continue;
                        newRoleResponsibility.setVersionNumber(origResponsibilityImpl.getVersionNumber());
                        newRoleResponsibility.setObjectId(origResponsibilityImpl.getObjectId());
                    }
                }
                roleResponsibilities.add(newRoleResponsibility);
            }
        }
        return roleResponsibilities;
    }

    private List<RoleResponsibilityActionBo> getRoleResponsibilitiesActions(IdentityManagementRoleDocument identityManagementRoleDocument) {
        ArrayList<RoleResponsibilityActionBo> roleRspActions = new ArrayList<RoleResponsibilityActionBo>();
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getResponsibilities())) {
            for (KimDocumentRoleResponsibility roleResponsibility : identityManagementRoleDocument.getResponsibilities()) {
                List<KimDocumentRoleResponsibilityAction> documentRoleResponsibilityActions;
                if (this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResponsibility.getResponsibilityId()) || !ObjectUtils.isNotNull(documentRoleResponsibilityActions = roleResponsibility.getRoleRspActions()) || documentRoleResponsibilityActions.isEmpty() || !StringUtils.isNotBlank((String)documentRoleResponsibilityActions.get(0).getRoleResponsibilityActionId())) continue;
                RoleResponsibilityActionBo roleRspAction = new RoleResponsibilityActionBo();
                roleRspAction.setId(documentRoleResponsibilityActions.get(0).getRoleResponsibilityActionId());
                roleRspAction.setActionPolicyCode(documentRoleResponsibilityActions.get(0).getActionPolicyCode());
                roleRspAction.setActionTypeCode(documentRoleResponsibilityActions.get(0).getActionTypeCode());
                roleRspAction.setPriorityNumber(documentRoleResponsibilityActions.get(0).getPriorityNumber());
                roleRspAction.setForceAction(documentRoleResponsibilityActions.get(0).isForceAction());
                roleRspAction.setRoleMemberId("*");
                roleRspAction.setRoleResponsibilityId(documentRoleResponsibilityActions.get(0).getRoleResponsibilityId());
                this.updateResponsibilityActionVersionNumber(roleRspAction, this.getRoleResponsibilityActionImpl(roleRspAction.getId()));
                roleRspActions.add(roleRspAction);
            }
        }
        return roleRspActions;
    }

    private void updateResponsibilityActionVersionNumber(RoleResponsibilityActionBo newRoleRspAction, RoleResponsibilityActionBo origRoleRespActionImpl) {
        if (ObjectUtils.isNotNull((Object)origRoleRespActionImpl) && origRoleRespActionImpl.getId() != null && StringUtils.equals((String)origRoleRespActionImpl.getId(), (String)newRoleRspAction.getId())) {
            newRoleRspAction.setVersionNumber(origRoleRespActionImpl.getVersionNumber());
            newRoleRspAction.setObjectId(origRoleRespActionImpl.getObjectId());
        }
    }

    private List<RoleResponsibilityActionBo> getRoleMemberResponsibilityActions(List<RoleMemberBo> newRoleMembersList) {
        ArrayList<RoleResponsibilityActionBo> roleRspActions = new ArrayList<RoleResponsibilityActionBo>();
        if (ObjectUtils.isNotNull(newRoleMembersList)) {
            for (RoleMemberBo roleMember : newRoleMembersList) {
                if (roleMember.getRoleRspActions() == null) continue;
                roleRspActions.addAll(roleMember.getRoleRspActions());
            }
        }
        return roleRspActions;
    }

    private List<RoleMemberBo> getRoleMembers(IdentityManagementRoleDocument identityManagementRoleDocument, List<RoleMemberBo> origRoleMembers) {
        if (CollectionUtils.isEmpty(identityManagementRoleDocument.getModifiedMembers())) {
            return new ArrayList<RoleMemberBo>();
        }
        ArrayList<RoleMemberBo> roleMembers = new ArrayList<RoleMemberBo>();
        for (KimDocumentRoleMember documentRoleMember : identityManagementRoleDocument.getModifiedMembers()) {
            boolean isNewRoleMember = true;
            for (RoleMemberBo roleMember : origRoleMembers) {
                if (!StringUtils.equals((String)roleMember.getId(), (String)documentRoleMember.getRoleMemberId())) continue;
                isNewRoleMember = false;
                boolean roleMemberWasActive = roleMember.isActive();
                roleMember.setActiveFromDateValue(documentRoleMember.getActiveFromDate());
                roleMember.setActiveToDateValue(documentRoleMember.getActiveToDate());
                this.updateRoleMemberResponsibilityActions(documentRoleMember.getRoleRspActions(), roleMember.getRoleRspActions());
                if (roleMemberWasActive && !documentRoleMember.isActive()) {
                    this.getRoleService().notifyOnMemberRemoval(RoleMemberBo.to((RoleMemberBo)roleMember));
                }
                roleMembers.add(roleMember);
                break;
            }
            if (!isNewRoleMember) continue;
            RoleMemberBo roleMember = new RoleMemberBo();
            roleMember.setId(documentRoleMember.getRoleMemberId());
            roleMember.setRoleId(identityManagementRoleDocument.getRoleId());
            roleMember.setTypeCode(documentRoleMember.getMemberTypeCode());
            roleMember.setMemberId(documentRoleMember.getMemberId());
            roleMember.setType(MemberType.fromCode((String)documentRoleMember.getMemberTypeCode()));
            roleMember.setActiveFromDateValue(documentRoleMember.getActiveFromDate());
            roleMember.setActiveToDateValue(documentRoleMember.getActiveToDate());
            roleMember.setVersionNumber(null);
            roleMember.setAttributeDetails(this.getRoleMemberAttributeData(documentRoleMember.getQualifiers(), null));
            roleMember.setRoleRspActions(new ArrayList());
            this.updateRoleMemberResponsibilityActions(documentRoleMember.getRoleRspActions(), roleMember.getRoleRspActions());
            roleMembers.add(roleMember);
        }
        List notModified = origRoleMembers.stream().filter(orm -> roleMembers.stream().noneMatch(rm -> orm.getId().equals(rm.getId()))).collect(Collectors.toList());
        roleMembers.addAll(notModified);
        return roleMembers;
    }

    private void updateRoleMemberResponsibilityActions(List<KimDocumentRoleResponsibilityAction> documentRoleMemberActions, List<RoleResponsibilityActionBo> roleMemberActions) {
        ArrayList<RoleResponsibilityActionBo> existingRoleMemberActions = new ArrayList<RoleResponsibilityActionBo>(roleMemberActions);
        for (KimDocumentRoleResponsibilityAction docRoleRspAction : documentRoleMemberActions) {
            boolean isNewAction = true;
            Iterator rraIterator = existingRoleMemberActions.iterator();
            while (rraIterator.hasNext()) {
                RoleResponsibilityActionBo roleRspAction = (RoleResponsibilityActionBo)rraIterator.next();
                if (StringUtils.equals((String)roleRspAction.getId(), (String)docRoleRspAction.getRoleResponsibilityActionId())) {
                    roleRspAction.setActionPolicyCode(docRoleRspAction.getActionPolicyCode());
                    roleRspAction.setActionTypeCode(docRoleRspAction.getActionTypeCode());
                    roleRspAction.setPriorityNumber(docRoleRspAction.getPriorityNumber());
                    roleRspAction.setRoleMemberId(docRoleRspAction.getRoleMemberId());
                    roleRspAction.setForceAction(docRoleRspAction.isForceAction());
                    rraIterator.remove();
                    isNewAction = false;
                }
                if (!isNewAction) continue;
                RoleResponsibilityActionBo newRoleRspAction = new RoleResponsibilityActionBo();
                newRoleRspAction.setId(docRoleRspAction.getRoleResponsibilityActionId());
                newRoleRspAction.setActionPolicyCode(docRoleRspAction.getActionPolicyCode());
                newRoleRspAction.setActionTypeCode(docRoleRspAction.getActionTypeCode());
                newRoleRspAction.setPriorityNumber(docRoleRspAction.getPriorityNumber());
                newRoleRspAction.setRoleMemberId(docRoleRspAction.getRoleMemberId());
                newRoleRspAction.setForceAction(docRoleRspAction.isForceAction());
                newRoleRspAction.setRoleResponsibilityId("*");
                roleMemberActions.add(newRoleRspAction);
            }
            for (RoleResponsibilityActionBo missingRra : existingRoleMemberActions) {
                roleMemberActions.remove(missingRra);
            }
        }
    }

    private List<RoleMemberAttributeDataBo> getRoleMemberAttributeData(List<KimDocumentRoleQualifier> qualifiers, List<RoleMemberAttributeDataBo> origAttributes) {
        ArrayList<RoleMemberAttributeDataBo> roleMemberAttributeDataList = new ArrayList<RoleMemberAttributeDataBo>();
        if (CollectionUtils.isNotEmpty(qualifiers)) {
            for (KimDocumentRoleQualifier memberRoleQualifier : qualifiers) {
                if (!StringUtils.isNotBlank((String)memberRoleQualifier.getAttrVal())) continue;
                RoleMemberAttributeDataBo newRoleMemberAttributeData = new RoleMemberAttributeDataBo();
                newRoleMemberAttributeData.setId(memberRoleQualifier.getAttrDataId());
                newRoleMemberAttributeData.setAttributeValue(memberRoleQualifier.getAttrVal());
                newRoleMemberAttributeData.setAssignedToId(memberRoleQualifier.getRoleMemberId());
                newRoleMemberAttributeData.setKimTypeId(memberRoleQualifier.getKimTypId());
                newRoleMemberAttributeData.setKimAttributeId(memberRoleQualifier.getKimAttrDefnId());
                this.updateAttrValIfNecessary(newRoleMemberAttributeData);
                if (ObjectUtils.isNotNull(origAttributes)) {
                    for (RoleMemberAttributeDataBo origAttribute : origAttributes) {
                        if (origAttribute.getId() == null || !StringUtils.equals((String)origAttribute.getId(), (String)newRoleMemberAttributeData.getId())) continue;
                        newRoleMemberAttributeData.setVersionNumber(origAttribute.getVersionNumber());
                    }
                }
                roleMemberAttributeDataList.add(newRoleMemberAttributeData);
            }
        }
        return roleMemberAttributeDataList;
    }

    private void updateAttrValIfNecessary(RoleMemberAttributeDataBo roleMemberAttributeData) {
        if (this.doCheckboxLogic(roleMemberAttributeData.getKimTypeId(), roleMemberAttributeData.getKimAttributeId())) {
            this.convertCheckboxAttributeData(roleMemberAttributeData);
        }
    }

    private void formatAttrValIfNecessary(KimDocumentRoleQualifier roleQualifier) {
        if (this.doCheckboxLogic(roleQualifier.getKimTypId(), roleQualifier.getKimAttrDefnId())) {
            this.formatCheckboxAttributeData(roleQualifier);
        }
    }

    private boolean doCheckboxLogic(String kimTypeId, String attrId) {
        KimAttributeField attributeDefinition = this.getAttributeDefinition(kimTypeId, attrId);
        return attributeDefinition != null && attributeDefinition.getAttributeField().getControl() != null && (attributeDefinition.getAttributeField().getControl() instanceof RemotableCheckboxGroup || attributeDefinition.getAttributeField().getControl() instanceof RemotableCheckbox);
    }

    private void formatCheckboxAttributeData(KimDocumentRoleQualifier roleQualifier) {
        if (roleQualifier.getAttrVal().equals("Y")) {
            roleQualifier.setAttrVal("Yes");
        } else if (roleQualifier.getAttrVal().equals("N")) {
            roleQualifier.setAttrVal("No");
        }
    }

    private KimAttributeField getAttributeDefinition(String kimTypId, String attrDefnId) {
        List attributeMap;
        KimTypeAttribute attributeInfo;
        KimTypeService typeService;
        KimType type = this.getKimTypeInfoService().getKimType(kimTypId);
        if (type != null && StringUtils.isNotBlank((String)type.getServiceName()) && (typeService = (KimTypeService)KimImplServiceLocator.getBean((String)type.getServiceName())) != null && (attributeInfo = type.getAttributeDefinitionById(attrDefnId)) != null && (attributeMap = typeService.getAttributeDefinitions(type.getId())) != null) {
            return DataDictionaryTypeServiceHelper.findAttributeField((String)attributeInfo.getKimAttribute().getAttributeName(), (Collection)attributeMap);
        }
        return null;
    }

    private void convertCheckboxAttributeData(RoleMemberAttributeDataBo roleMemberAttributeData) {
        if (roleMemberAttributeData.getAttributeValue().equalsIgnoreCase("Yes")) {
            roleMemberAttributeData.setAttributeValue("Y");
        } else if (roleMemberAttributeData.getAttributeValue().equalsIgnoreCase("No")) {
            roleMemberAttributeData.setAttributeValue("N");
        }
    }

    private List<DelegateTypeBo> getRoleDelegations(IdentityManagementRoleDocument identityManagementRoleDocument, List<DelegateTypeBo> origDelegations) {
        ArrayList<DelegateTypeBo> kimDelegations = new ArrayList<DelegateTypeBo>();
        DelegateTypeBo origDelegationImplTemp = null;
        ArrayList<DelegateMemberBo> allOrigMembers = new ArrayList<DelegateMemberBo>();
        boolean activatingInactive = false;
        String newDelegationIdAssigned = "";
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getDelegations())) {
            for (RoleDocumentDelegation roleDocumentDelegation : identityManagementRoleDocument.getDelegations()) {
                DelegateTypeBo newKimDelegation = new DelegateTypeBo();
                KimCommonUtilsInternal.copyProperties(newKimDelegation, (Object)roleDocumentDelegation);
                newKimDelegation.setVersionNumber(null);
                newKimDelegation.setRoleId(identityManagementRoleDocument.getRoleId());
                if (ObjectUtils.isNotNull(origDelegations)) {
                    for (DelegateTypeBo origDelegationImpl : origDelegations) {
                        if (StringUtils.equals((String)origDelegationImpl.getRoleId(), (String)newKimDelegation.getRoleId()) && StringUtils.equals((String)origDelegationImpl.getDelegationId(), (String)newKimDelegation.getDelegationId())) {
                            newDelegationIdAssigned = newKimDelegation.getDelegationId();
                            newKimDelegation.setDelegationId(origDelegationImpl.getDelegationId());
                            activatingInactive = true;
                        }
                        if (origDelegationImpl.getDelegationId() != null && StringUtils.equals((String)origDelegationImpl.getDelegationId(), (String)newKimDelegation.getDelegationId())) {
                            newKimDelegation.setVersionNumber(origDelegationImpl.getVersionNumber());
                            newKimDelegation.setObjectId(origDelegationImpl.getObjectId());
                            origDelegationImplTemp = origDelegationImpl;
                        }
                        allOrigMembers.addAll(origDelegationImpl.getMembers());
                    }
                }
                ArrayList<DelegateMemberBo> origMembers = origDelegationImplTemp == null || origDelegationImplTemp.getMembers() == null ? new ArrayList() : origDelegationImplTemp.getMembers();
                newKimDelegation.setMembers(this.getDelegationMembers(roleDocumentDelegation.getMembers(), origMembers, allOrigMembers, activatingInactive, newDelegationIdAssigned));
                kimDelegations.add(newKimDelegation);
                activatingInactive = false;
            }
        }
        return kimDelegations;
    }

    private List<DelegateMemberBo> getDelegationMembers(List<RoleDocumentDelegationMember> delegationMembers, List<DelegateMemberBo> origDelegationMembers, List<DelegateMemberBo> allOrigMembers, boolean activatingInactive, String newDelegationIdAssigned) {
        ArrayList<DelegateMemberBo> delegationsMembersList = new ArrayList<DelegateMemberBo>();
        DelegateMemberBo origDelegationMemberImplTemp = null;
        String delegationMemberId = "";
        if (CollectionUtils.isNotEmpty(delegationMembers)) {
            for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
                DelegateMemberBo newDelegationMemberImpl = new DelegateMemberBo();
                KimCommonUtilsInternal.copyProperties(newDelegationMemberImpl, (Object)delegationMember);
                newDelegationMemberImpl.setType(MemberType.fromCode((String)delegationMember.getMemberTypeCode()));
                if (ObjectUtils.isNotNull(origDelegationMembers)) {
                    for (DelegateMemberBo origDelegationMember : origDelegationMembers) {
                        if (activatingInactive && StringUtils.equals((String)origDelegationMember.getMemberId(), (String)newDelegationMemberImpl.getMemberId()) && StringUtils.equals((String)newDelegationMemberImpl.getDelegationId(), (String)newDelegationIdAssigned) && !origDelegationMember.isActive(this.getDateTimeService().getCurrentTimestamp())) {
                            newDelegationMemberImpl.setDelegationId(origDelegationMember.getDelegationId());
                            delegationMemberId = newDelegationMemberImpl.getDelegationMemberId();
                            newDelegationMemberImpl.setDelegationMemberId(origDelegationMember.getDelegationMemberId());
                        }
                        if (origDelegationMember.getDelegationMemberId() == null || !StringUtils.equals((String)origDelegationMember.getDelegationMemberId(), (String)newDelegationMemberImpl.getDelegationMemberId())) continue;
                        newDelegationMemberImpl.setVersionNumber(origDelegationMember.getVersionNumber());
                        newDelegationMemberImpl.setObjectId(origDelegationMember.getObjectId());
                        origDelegationMemberImplTemp = origDelegationMember;
                    }
                }
                if (ObjectUtils.isNotNull(allOrigMembers)) {
                    for (DelegateMemberBo origMember : allOrigMembers) {
                        if (origMember.getDelegationMemberId() == null || !origMember.getDelegationMemberId().equals(delegationMember.getDelegationMemberId()) || origMember.getRoleMemberId() == null || !origMember.getRoleMemberId().equals(delegationMember.getRoleMemberId())) continue;
                        newDelegationMemberImpl.setVersionNumber(origMember.getVersionNumber());
                        newDelegationMemberImpl.setObjectId(origMember.getObjectId());
                        origDelegationMemberImplTemp = origMember;
                    }
                }
                ArrayList<DelegateMemberAttributeDataBo> origAttributes = origDelegationMemberImplTemp == null || origDelegationMemberImplTemp.getAttributeDetails() == null ? new ArrayList() : origDelegationMemberImplTemp.getAttributeDetails();
                newDelegationMemberImpl.setAttributeDetails(this.getDelegationMemberAttributeData(delegationMember.getQualifiers(), origAttributes, activatingInactive, delegationMemberId));
                newDelegationMemberImpl.setActiveFromDateValue(delegationMember.getActiveFromDate());
                newDelegationMemberImpl.setActiveToDateValue(delegationMember.getActiveToDate());
                newDelegationMemberImpl.setVersionNumber(null);
                delegationsMembersList.add(newDelegationMemberImpl);
            }
        }
        return delegationsMembersList;
    }

    private List<DelegateMemberAttributeDataBo> getDelegationMemberAttributeData(List<RoleDocumentDelegationMemberQualifier> qualifiers, List<DelegateMemberAttributeDataBo> origAttributes, boolean activatingInactive, String delegationMemberId) {
        ArrayList<DelegateMemberAttributeDataBo> delegationMemberAttributeDataList = new ArrayList<DelegateMemberAttributeDataBo>();
        if (CollectionUtils.isNotEmpty(qualifiers)) {
            for (RoleDocumentDelegationMemberQualifier memberRoleQualifier : qualifiers) {
                if (!StringUtils.isNotBlank((String)memberRoleQualifier.getAttrVal())) continue;
                DelegateMemberAttributeDataBo newDelegationMemberAttributeData = new DelegateMemberAttributeDataBo();
                newDelegationMemberAttributeData.setId(memberRoleQualifier.getAttrDataId());
                newDelegationMemberAttributeData.setAttributeValue(memberRoleQualifier.getAttrVal());
                newDelegationMemberAttributeData.setAssignedToId(memberRoleQualifier.getDelegationMemberId());
                newDelegationMemberAttributeData.setKimTypeId(memberRoleQualifier.getKimTypId());
                newDelegationMemberAttributeData.setKimAttributeId(memberRoleQualifier.getKimAttrDefnId());
                if (ObjectUtils.isNotNull(origAttributes)) {
                    for (DelegateMemberAttributeDataBo origAttribute : origAttributes) {
                        if (activatingInactive && StringUtils.equals((String)origAttribute.getKimAttributeId(), (String)newDelegationMemberAttributeData.getKimAttributeId()) && StringUtils.equals((String)newDelegationMemberAttributeData.getAssignedToId(), (String)delegationMemberId)) {
                            newDelegationMemberAttributeData.setAssignedToId(origAttribute.getAssignedToId());
                            newDelegationMemberAttributeData.setId(origAttribute.getId());
                        }
                        if (!StringUtils.equals((String)origAttribute.getId(), (String)newDelegationMemberAttributeData.getId())) continue;
                        newDelegationMemberAttributeData.setVersionNumber(origAttribute.getVersionNumber());
                    }
                }
                delegationMemberAttributeDataList.add(newDelegationMemberAttributeData);
            }
        }
        return delegationMemberAttributeDataList;
    }

    @Override
    public void loadGroupDoc(IdentityManagementGroupDocument identityManagementGroupDocument, Group groupInfo) {
        identityManagementGroupDocument.setGroupId(groupInfo.getId());
        KimType kimType = this.getKimTypeInfoService().getKimType(groupInfo.getKimTypeId());
        identityManagementGroupDocument.setKimType(kimType);
        identityManagementGroupDocument.setGroupTypeName(kimType.getName());
        identityManagementGroupDocument.setGroupTypeId(kimType.getId());
        identityManagementGroupDocument.setGroupName(groupInfo.getName());
        identityManagementGroupDocument.setGroupDescription(groupInfo.getDescription());
        identityManagementGroupDocument.setActive(groupInfo.isActive());
        identityManagementGroupDocument.setGroupNamespace(groupInfo.getNamespaceCode());
        ArrayList<GroupMember> members = new ArrayList<GroupMember>(this.getGroupService().getCurrentAndFutureMembers(groupInfo.getId()));
        identityManagementGroupDocument.setMembers(this.loadGroupMembers(identityManagementGroupDocument, members));
        identityManagementGroupDocument.setQualifiers(this.loadGroupQualifiers(identityManagementGroupDocument, groupInfo.getAttributes()));
        identityManagementGroupDocument.setEditing(true);
    }

    private List<GroupDocumentMember> loadGroupMembers(IdentityManagementGroupDocument identityManagementGroupDocument, List<GroupMember> members) {
        ArrayList<GroupDocumentMember> pndMembers = new ArrayList<GroupDocumentMember>();
        if (ObjectUtils.isNotNull(members)) {
            for (GroupMember member : members) {
                GroupDocumentMember pndMember = new GroupDocumentMember();
                pndMember.setActiveFromDate(member.getActiveFromDate() == null ? null : new Timestamp(member.getActiveFromDate().getMillis()));
                pndMember.setActiveToDate(member.getActiveToDate() == null ? null : new Timestamp(member.getActiveToDate().getMillis()));
                pndMember.setGroupMemberId(member.getMemberId());
                pndMember.setGroupId(member.getGroupId());
                pndMember.setMemberId(member.getMemberId());
                pndMember.setMemberName(this.getMemberName(member.getType(), member.getMemberId()));
                pndMember.setMemberFullName(this.getMemberFullName(member.getType(), member.getMemberId()));
                pndMember.setMemberTypeCode(member.getType().getCode());
                pndMember.setEdit(true);
                pndMembers.add(pndMember);
            }
        }
        pndMembers.sort((m1, m2) -> m1.getMemberName().compareToIgnoreCase(m2.getMemberName()));
        return pndMembers;
    }

    private List<GroupDocumentQualifier> loadGroupQualifiers(IdentityManagementGroupDocument IdentityManagementGroupDocument2, Map<String, String> attributes) {
        ArrayList<GroupDocumentQualifier> pndGroupQualifiers = new ArrayList<GroupDocumentQualifier>();
        List<KimAttributeField> origAttributes = IdentityManagementGroupDocument2.getDefinitions();
        boolean attributePresent = false;
        if (origAttributes != null) {
            for (KimAttributeField key : origAttributes) {
                GroupDocumentQualifier pndGroupQualifier;
                String origAttributeId = IdentityManagementGroupDocument2.getKimAttributeDefnId(key);
                if (!attributes.isEmpty()) {
                    for (GroupAttributeBo groupQualifier : KimAttributeDataBo.createFrom(GroupAttributeBo.class, attributes, (String)IdentityManagementGroupDocument2.getGroupTypeId())) {
                        if (origAttributeId == null || !ObjectUtils.isNotNull((Object)groupQualifier.getKimAttribute()) || !StringUtils.equals((String)origAttributeId, (String)groupQualifier.getKimAttribute().getId())) continue;
                        pndGroupQualifier = new GroupDocumentQualifier();
                        KimCommonUtilsInternal.copyProperties((Object)pndGroupQualifier, groupQualifier);
                        pndGroupQualifier.setAttrDataId(groupQualifier.getId());
                        pndGroupQualifier.setAttrVal(groupQualifier.getAttributeValue());
                        pndGroupQualifier.setKimAttrDefnId(groupQualifier.getKimAttribute().getId());
                        pndGroupQualifier.setKimTypId(groupQualifier.getKimType().getId());
                        pndGroupQualifier.setGroupId(groupQualifier.getAssignedToId());
                        pndGroupQualifiers.add(pndGroupQualifier);
                        attributePresent = true;
                    }
                }
                if (!attributePresent) {
                    pndGroupQualifier = new GroupDocumentQualifier();
                    pndGroupQualifier.setKimAttrDefnId(origAttributeId);
                    pndGroupQualifiers.add(pndGroupQualifier);
                }
                attributePresent = false;
            }
        }
        return pndGroupQualifiers;
    }

    @Override
    public void saveGroup(IdentityManagementGroupDocument identityManagementGroupDocument) {
        GroupBo kimGroup = new GroupBo();
        String groupId = identityManagementGroupDocument.getGroupId();
        GroupBo origGroup = (GroupBo)this.getDataObjectService().find(GroupBo.class, (Object)groupId);
        ArrayList<GroupMemberBo> origGroupMembers = new ArrayList();
        if (ObjectUtils.isNull((Object)origGroup)) {
            origGroup = new GroupBo();
            kimGroup.setActive(true);
        } else {
            kimGroup.setVersionNumber(origGroup.getVersionNumber());
            kimGroup.setActive(identityManagementGroupDocument.isActive());
            origGroupMembers = this.getDataObjectService().findMatching(GroupMemberBo.class, QueryByCriteria.Builder.forAttribute((String)"id", (Object)groupId).build()).getResults();
        }
        kimGroup.setId(identityManagementGroupDocument.getGroupId());
        KimType kimType = this.getKimTypeInfoService().getKimType(identityManagementGroupDocument.getGroupTypeId());
        if (kimType == null) {
            throw new RuntimeException("Kim type not found for:" + identityManagementGroupDocument.getGroupTypeId());
        }
        kimGroup.setKimTypeId(kimType.getId());
        kimGroup.setNamespaceCode(identityManagementGroupDocument.getGroupNamespace());
        kimGroup.setName(identityManagementGroupDocument.getGroupName());
        kimGroup.setDescription(identityManagementGroupDocument.getGroupDescription());
        kimGroup.setAttributeDetails(this.getGroupAttributeData(identityManagementGroupDocument, origGroup.getAttributeDetails()));
        List oldIds = this.getGroupService().getMemberPrincipalIds(kimGroup.getId());
        List newGroupMembersList = this.getGroupMembers(identityManagementGroupDocument, origGroupMembers).stream().map(newGroupMember -> (GroupMemberBo)this.getDataObjectService().save(newGroupMember, new PersistenceOption[0])).collect(Collectors.toList());
        kimGroup.setMembers(newGroupMembersList);
        kimGroup = (GroupBo)this.getDataObjectService().save((Object)kimGroup, new PersistenceOption[]{PersistenceOption.FLUSH});
        List newIds = kimGroup.getMemberPrincipalIds();
        this.getGroupInternalService().updateForWorkgroupChange(kimGroup.getId(), oldIds, newIds);
        if (!kimGroup.isActive()) {
            this.getRoleInternalService().groupInactivated(identityManagementGroupDocument.getGroupId());
        }
    }

    private List<GroupMemberBo> getGroupMembers(IdentityManagementGroupDocument identityManagementGroupDocument, List<GroupMemberBo> origGroupMembers) {
        return CollectionUtils.isNotEmpty(identityManagementGroupDocument.getMembers()) ? identityManagementGroupDocument.getMembers().stream().map(documentGroupMember -> {
            GroupMemberBo newGroupMember = new GroupMemberBo();
            newGroupMember.setGroupId(identityManagementGroupDocument.getGroupId());
            newGroupMember.setActiveFromDateValue(documentGroupMember.getActiveFromDate());
            newGroupMember.setActiveToDateValue(documentGroupMember.getActiveToDate());
            newGroupMember.setMemberId(documentGroupMember.getMemberId());
            newGroupMember.setTypeCode(documentGroupMember.getMemberTypeCode());
            newGroupMember.setVersionNumber(null);
            if (ObjectUtils.isNotNull((Object)origGroupMembers)) {
                origGroupMembers.forEach(origGroupMemberImpl -> {
                    if (StringUtils.equals((String)origGroupMemberImpl.getGroupId(), (String)newGroupMember.getGroupId()) && StringUtils.equals((String)origGroupMemberImpl.getMemberId(), (String)newGroupMember.getMemberId()) && !origGroupMemberImpl.isActive(this.getDateTimeService().getCurrentTimestamp())) {
                        newGroupMember.setMemberId(origGroupMemberImpl.getMemberId());
                    }
                    if (StringUtils.equals((String)origGroupMemberImpl.getGroupId(), (String)newGroupMember.getGroupId()) && StringUtils.equals((String)origGroupMemberImpl.getMemberId(), (String)newGroupMember.getMemberId()) && origGroupMemberImpl.isActive(this.getDateTimeService().getCurrentTimestamp())) {
                        newGroupMember.setId(origGroupMemberImpl.getId());
                        newGroupMember.setVersionNumber(origGroupMemberImpl.getVersionNumber());
                    }
                });
            }
            return newGroupMember;
        }).collect(Collectors.toList()) : new ArrayList<GroupMemberBo>();
    }

    private List<GroupAttributeBo> getGroupAttributeData(IdentityManagementGroupDocument identityManagementGroupDocument, List<GroupAttributeBo> origAttributes) {
        ArrayList<GroupAttributeBo> groupAttributeDataList = new ArrayList<GroupAttributeBo>();
        if (CollectionUtils.isNotEmpty(identityManagementGroupDocument.getQualifiers())) {
            for (GroupDocumentQualifier groupQualifier : identityManagementGroupDocument.getQualifiers()) {
                if (!StringUtils.isNotBlank((String)groupQualifier.getAttrVal())) continue;
                GroupAttributeBo newGroupAttributeData = new GroupAttributeBo();
                newGroupAttributeData.setId(groupQualifier.getAttrDataId());
                newGroupAttributeData.setAttributeValue(groupQualifier.getAttrVal());
                newGroupAttributeData.setAssignedToId(groupQualifier.getGroupId());
                newGroupAttributeData.setKimTypeId(groupQualifier.getKimTypId());
                newGroupAttributeData.setKimAttributeId(groupQualifier.getKimAttrDefnId());
                if (ObjectUtils.isNotNull(origAttributes)) {
                    for (GroupAttributeBo origAttribute : origAttributes) {
                        if (StringUtils.equals((String)origAttribute.getKimAttributeId(), (String)newGroupAttributeData.getKimAttributeId()) && StringUtils.equals((String)newGroupAttributeData.getAssignedToId(), (String)origAttribute.getAssignedToId())) {
                            newGroupAttributeData.setId(origAttribute.getId());
                        }
                        if (origAttribute.getId() == null || !StringUtils.equals((String)origAttribute.getId(), (String)newGroupAttributeData.getId())) continue;
                        newGroupAttributeData.setVersionNumber(origAttribute.getVersionNumber());
                    }
                }
                groupAttributeDataList.add(newGroupAttributeData);
            }
        }
        return groupAttributeDataList;
    }

    private Set<String> getChangedRoleResponsibilityIds(IdentityManagementRoleDocument identityManagementRoleDocument, List<RoleResponsibilityBo> origRoleResponsibilities) {
        HashSet<String> lRet = new HashSet<String>();
        ArrayList<String> newResp = new ArrayList<String>();
        ArrayList<String> oldResp = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(identityManagementRoleDocument.getResponsibilities())) {
            for (KimDocumentRoleResponsibility documentRoleResponsibility : identityManagementRoleDocument.getResponsibilities()) {
                newResp.add(documentRoleResponsibility.getResponsibilityId());
            }
        }
        if (ObjectUtils.isNotNull(origRoleResponsibilities)) {
            for (RoleResponsibilityBo roleRespBo : origRoleResponsibilities) {
                oldResp.add(roleRespBo.getResponsibilityId());
            }
        }
        lRet.addAll(newResp);
        lRet.addAll(oldResp);
        return lRet;
    }

    @Override
    public List<KimDocumentRoleMember> getRoleMembers(Map<String, String> fieldValues) {
        ArrayList<KimDocumentRoleMember> matchingRoleMembers = new ArrayList<KimDocumentRoleMember>();
        fieldValues.remove("backLocation");
        fieldValues.remove("docFormKey");
        fieldValues.remove("docNum");
        List matchingRoleMembersTemp = this.getRoleService().findRoleMembers(this.toQuery(fieldValues)).getResults();
        if (CollectionUtils.isNotEmpty((Collection)matchingRoleMembersTemp)) {
            for (RoleMember roleMember : matchingRoleMembersTemp) {
                RoleMemberBo roleMemberBo = this.getRoleMember(roleMember.getId());
                Object roleMemberObject = this.getMember(roleMemberBo.getType(), roleMemberBo.getMemberId());
                KimDocumentRoleMember matchingRoleMember = new KimDocumentRoleMember();
                KimDocumentRoleMember.copyProperties(matchingRoleMember, roleMemberBo);
                matchingRoleMember.setMemberId(roleMemberBo.getMemberId());
                matchingRoleMember.setRoleMemberId(roleMemberBo.getId());
                matchingRoleMember.setMemberName(this.getMemberName(roleMemberBo.getType(), roleMemberObject));
                matchingRoleMember.setMemberNamespaceCode(this.getMemberNamespaceCode(roleMemberBo.getType(), roleMemberObject));
                matchingRoleMember.setQualifiers(this.getQualifiers(roleMemberBo.getAttributeDetails()));
                matchingRoleMembers.add(matchingRoleMember);
            }
        }
        return matchingRoleMembers;
    }

    private QueryByCriteria toQuery(Map<String, String> fieldValues) {
        String memberId;
        String memberTypeCode = fieldValues.get("typeCode");
        String memberName = fieldValues.get("memberName");
        String memberNamespaceCode = fieldValues.get("memberNamespaceCode");
        if ((StringUtils.isNotEmpty((String)memberName) || StringUtils.isNotEmpty((String)memberNamespaceCode)) && StringUtils.isNotEmpty((String)(memberId = this.getMemberIdByName(MemberType.fromCode((String)memberTypeCode), memberNamespaceCode, memberName)))) {
            fieldValues.put("id", memberId);
        }
        ArrayList<Predicate> pred = new ArrayList<Predicate>();
        pred.add(PredicateUtils.convertMapToPredicate(fieldValues));
        Predicate[] predicates = new Predicate[]{};
        predicates = pred.toArray(predicates);
        return QueryByCriteria.Builder.fromPredicates((Predicate[])predicates);
    }

    private List<KimDocumentRoleQualifier> getQualifiers(List<RoleMemberAttributeDataBo> attributes) {
        if (attributes == null) {
            return null;
        }
        ArrayList<KimDocumentRoleQualifier> qualifiers = new ArrayList<KimDocumentRoleQualifier>();
        if (ObjectUtils.isNotNull(attributes)) {
            for (RoleMemberAttributeDataBo attribute : attributes) {
                KimDocumentRoleQualifier qualifier = new KimDocumentRoleQualifier();
                qualifier.setAttrDataId(attribute.getId());
                qualifier.setAttrVal(attribute.getAttributeValue());
                qualifier.setRoleMemberId(attribute.getAssignedToId());
                qualifier.setKimTypId(attribute.getKimTypeId());
                qualifier.setKimAttrDefnId(attribute.getKimAttributeId());
                qualifier.setKimAttribute(attribute.getKimAttribute());
                qualifiers.add(qualifier);
            }
        }
        return qualifiers;
    }

    public ResponsibilityInternalService getResponsibilityInternalService() {
        if (this.responsibilityInternalService == null) {
            this.responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return this.responsibilityInternalService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        }
        return this.dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public IdentityArchiveService getIdentityArchiveService() {
        if (this.identityArchiveService == null) {
            this.identityArchiveService = (IdentityArchiveService)GlobalResourceLoader.getService((String)KIM_IDENTITY_ARCHIVE_SERVICE);
        }
        return this.identityArchiveService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected GroupInternalService getGroupInternalService() {
        if (this.groupInternalService == null) {
            this.groupInternalService = KimImplServiceLocator.getGroupInternalService();
        }
        return this.groupInternalService;
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    protected RoleInternalService getRoleInternalService() {
        if (this.roleInternalService == null) {
            this.roleInternalService = KimImplServiceLocator.getRoleInternalService();
        }
        return this.roleInternalService;
    }

    public void setRoleInternalService(RoleInternalService roleInternalService) {
        this.roleInternalService = roleInternalService;
    }

    public KimTypeInfoService getKimTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }
}

