/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service;

import org.kuali.rice.kcb.api.service.MessagingService;
import org.quartz.JobDetail;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * Service locator interface for the KCB module.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface KCBServiceLocator {
    public JobDetail getMessageProcessingJobDetail();
    public PlatformTransactionManager getTransactionManager();
    public MessageDeliveryService getMessageDeliveryService();
    public MessageService getKcbMessageService();
    public MessagingService getMessagingService();
    public MessageDelivererRegistryService getMessageDelivererRegistryService();
    public EmailService getEmailService();
    public RecipientPreferenceService getRecipientPreferenceService();
    public KENIntegrationService getKenIntegrationService();
}
