/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.dao.impl;

import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.dao.NotificationDao;
import org.kuali.rice.ken.util.NotificationConstants;
import org.kuali.rice.krad.data.DataObjectService;

import java.sql.Timestamp;
import java.util.Collection;

import static org.kuali.rice.core.api.criteria.PredicateFactory.and;
import static org.kuali.rice.core.api.criteria.PredicateFactory.lessThanOrEqual;
import static org.kuali.rice.core.api.criteria.PredicateFactory.equal;
import static org.kuali.rice.core.api.criteria.PredicateFactory.isNull;

public class NotificationDaoJpa implements NotificationDao{

	@Override
	public Collection findMatchedNotificationsForResolution(Timestamp tm, DataObjectService dataObjectService) {

		//LOG.info("************************calling JPANotificationDao.findMatchedNotificationsForResolution(************************ ");

        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(
            and(
                equal(NotificationConstants.BO_PROPERTY_NAMES.PROCESSING_FLAG, NotificationConstants.PROCESSING_FLAGS.UNRESOLVED),
                lessThanOrEqual(NotificationConstants.BO_PROPERTY_NAMES.SEND_DATE_TIME, new Timestamp(System.currentTimeMillis())),
                isNull(NotificationConstants.BO_PROPERTY_NAMES.LOCKED_DATE)
            )
        );

        return dataObjectService.findMatching(NotificationBo.class, criteria.build()).getResults();
	}

	@Override
	public Collection findMatchedNotificationsForUnlock(NotificationBo not, DataObjectService dataObjectService) {

		//LOG.info("************************calling JPANotificationDao.findMatchedNotificationsForForUnlock************************ ");

		QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(equal(NotificationConstants.BO_PROPERTY_NAMES.ID, not.getId()));

        Collection<NotificationBo> notifications = dataObjectService.findMatching(NotificationBo.class, criteria.build()).getResults();

		return notifications;
	}
}

