/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actions;

import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;


/**
 * Used to determine store notifications to be sent in the {@link BlanketApproveEngine}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NotificationContext {

    private String notificationRequestCode;
    private PrincipalContract principalTakingAction;
    private String actionTakenCode;
    
    public NotificationContext(String notificationRequestCode, PrincipalContract principalTakingAction, String actionTakenCode) {
        this.notificationRequestCode = notificationRequestCode;
        this.principalTakingAction = principalTakingAction;
        this.actionTakenCode = actionTakenCode;
    }

    public String getActionTakenCode() {
        return actionTakenCode;
    }

    public String getNotificationRequestCode() {
        return notificationRequestCode;
    }

    public PrincipalContract getPrincipalTakingAction() {
        return principalTakingAction;
    }
    
    

}
