/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

import org.kuali.rice.kew.engine.node.RouteNodeInstance;

import java.util.ArrayList;
import java.util.List;

/**
 * Maintains context of the main processing loop of the workflow engine.  Essentially 
 * contains a List of node instances which need to be processed.  After a node instance
 * is processed from the context, the engine will check the status of the complete
 * flag to determine whether processing should continue or halt.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ProcessContext {

    private boolean complete = true;
    private final List<RouteNodeInstance> nextNodeInstances;
    
    public ProcessContext() {
        this(true, new ArrayList<RouteNodeInstance>());
    }
    
    public ProcessContext(boolean complete, List<RouteNodeInstance> nextNodeInstances) {
        this.complete = complete;
        this.nextNodeInstances = nextNodeInstances;
    }

    public List<RouteNodeInstance> getNextNodeInstances() {
        return nextNodeInstances;
    }
    
    public boolean isComplete() {
        return complete;
    }
    
    public void setComplete(boolean complete) {
        this.complete = complete;
    }
    
}
