/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.List;

/**
 * The result of a node graph search.  Indentifies the node instance which was found in the search and also the
 * path followed to find the node.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NodeGraphSearchResult {
	
	private RouteNodeInstance resultNodeInstance;
	private List path = new ArrayList();
	
	public NodeGraphSearchResult(RouteNodeInstance resultNodeInstance, List path) {
		this.resultNodeInstance = resultNodeInstance;
		this.path = path;
	}

	public RouteNodeInstance getResultNodeInstance() {
		return resultNodeInstance;
	}

	public void setResultNodeInstance(RouteNodeInstance resultNodeInstance) {
		this.resultNodeInstance = resultNodeInstance;
	}

	public List getPath() {
		return path;
	}

	public void setPath(List path) {
		this.path = path;
	}
	
	

}
