/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.api.doctype.ProcessDefinitionContract;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.krad.data.jpa.converters.Boolean01Converter;

import javax.persistence.*;
import java.io.Serializable;


/**
 * Represents a route path defined on a {@link DocumentType}.  A ProcessDefinition is a named entity which
 * simply points to an initial {@link RouteNode} which represents the beginning of the ProcessDefinition.
 * The path of the process can then be followed using the next nodes defined on the route nodes. 
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name="KREW_DOC_TYP_PROC_T")
//@Sequence(name="KREW_RTE_NODE_S",property="processId")
public class ProcessDefinitionBo implements Serializable, ProcessDefinitionContract {

	private static final long serialVersionUID = -6338857095673479752L;
    
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
	@Column(name="DOC_TYP_PROC_ID")
	private String processId;
	@Column(name="NM")
	private String name;
	@ManyToOne(fetch=FetchType.EAGER)
	@JoinColumn(name="DOC_TYP_ID")
	private DocumentType documentType;
	@OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
	@JoinColumn(name="INIT_RTE_NODE_ID")
	private RouteNode initialRouteNode;
    @Column(name="INIT_IND")
	@Convert(converter=Boolean01Converter.class)
	private boolean initial = false;
	@Version
	@Column(name="VER_NBR")
	private Integer lockVerNbr;
	
	public String getProcessId() {
		return processId;
	}
	public void setProcessId(String processId) {
		this.processId = processId;
	}
	public DocumentType getDocumentType() {
		return documentType;
	}
	public void setDocumentType(DocumentType documentType) {
		this.documentType = documentType;
	}
	@Override
    public RouteNode getInitialRouteNode() {
		return initialRouteNode;
	}
	public void setInitialRouteNode(RouteNode initialRouteNode) {
		this.initialRouteNode = initialRouteNode;
	}
	@Override
    public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@Override
    public boolean isInitial() {
		return initial;
	}
	public void setInitial(boolean initial) {
		this.initial = initial;
	}
	public Integer getLockVerNbr() {
		return lockVerNbr;
	}
	public void setLockVerNbr(Integer lockVerNbr) {
		this.lockVerNbr = lockVerNbr;
	}

	@Override
    public String getId() {
        if (processId == null) {
            return null;
        }
        return processId.toString();
    }

    @Override
    public Long getVersionNumber() {
        if (lockVerNbr == null) {
            return null;
        }
        return new Long(lockVerNbr.longValue());
    }

    @Override
    public String getDocumentTypeId() {
        if (documentType == null) {
            return null;
        }
        return documentType.getId();
    }

}
