/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var.schemes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;


/**
 * A property scheme that interprets the locator as a URL.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class URLScheme implements PropertyScheme {
    private static final Logger LOG = LogManager.getLogger(URLScheme.class);

    @Override
    public String getName() {
        return "url";
    }
    @Override
    public String getShortName() {
        return "url";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        LOG.info("Reading url '" + property.locator + "'...");
        InputStream is;
        try {
            is = new URL(property.locator).openStream();
            if (is == null) {
                throw new RuntimeException("Unable to access URL: " + property.locator);
            }
            return PropertiesUtil.readResource(is);
        } catch (IOException ioe) {
            throw new RuntimeException("Error loading resource: " + property.locator, ioe);
        }
    }

    @Override
    public String toString() {
        return "[URLScheme]";
    }
}
