/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.role;

import org.kuali.rice.kew.engine.RouteContext;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Implementation of the Null Object Pattern for QualiferResolvers.  Returns an List with a single empty
 * Map<String, String> when asked to resolve.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class NullQualifierResolver implements QualifierResolver {

	@Override
    public List<Map<String, String>> resolve(RouteContext context) {
		return Collections.<Map<String, String>>singletonList(new HashMap<String, String>());
	}

}
