/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routing.web;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;


/**
 * A Struts Action for redirecting from the KEW web application to the appropriate
 * Doc Handler for a document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ClientAppDocHandlerRedirectAction extends KewKualiAction {

    @Override
	public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DocHandlerForm docHandlerForm = (DocHandlerForm) form;

        String docHandler = null;

        if (request.getParameter(KewApiConstants.DOCUMENT_ID_PARAMETER) != null) {
            RouteHeaderService rhSrv = (RouteHeaderService) KEWServiceLocator.getService(KEWServiceLocator.DOC_ROUTE_HEADER_SRV);
            DocumentRouteHeaderValue routeHeader = rhSrv.getRouteHeader(docHandlerForm.getDocId());

            if (!KEWServiceLocator.getDocumentSecurityService().routeLogAuthorized(GlobalVariables.getUserSession().getPrincipalId(), routeHeader, new SecuritySession(GlobalVariables.getUserSession().getPrincipalId()))) {
            	return mapping.findForward("NotAuthorized");
            }
            docHandler = routeHeader.getDocumentType().getResolvedDocumentHandlerUrl();
            if (StringUtils.isBlank(docHandler)) {
                throw new WorkflowRuntimeException("Document Type '" + routeHeader.getDocumentType().getName() + "' does not have a document handler url set (attempted to open document handler url for document id " + routeHeader.getDocumentId() + ")");
            }
            if (!docHandler.contains("?")) {
                docHandler += "?";
            } else {
                docHandler += "&";
            }
            docHandler += KewApiConstants.DOCUMENT_ID_PARAMETER + "=" + docHandlerForm.getDocId();
            if (StringUtils.isNotBlank(routeHeader.getAppDocId())) {
                docHandler += "&" + KewApiConstants.APP_DOC_ID_PARAMETER + "=" + URLEncoder.encode(routeHeader.getAppDocId(), StandardCharsets.UTF_8);
            }
        } else if (request.getParameter(KewApiConstants.DOCTYPE_PARAMETER) != null) {
            DocumentTypeService documentTypeService = (DocumentTypeService) KEWServiceLocator.getService(KEWServiceLocator.DOCUMENT_TYPE_SERVICE);
            DocumentType documentType = documentTypeService.findByName(docHandlerForm.getDocTypeName());
            docHandler = documentType.getResolvedDocumentHandlerUrl();
            if (StringUtils.isBlank(docHandler)) {
                throw new WorkflowRuntimeException("Cannot find document handler url for document type '" + documentType.getName() + "'");
            }
            if (!docHandler.contains("?")) {
                docHandler += "?";
            } else {
                docHandler += "&";
            }
            docHandler += KewApiConstants.DOCTYPE_PARAMETER + "=" + docHandlerForm.getDocTypeName();
        } else {
//TODO what should happen here if parms are missing; no proper ActionForward from here
            throw new RuntimeException ("Cannot determine document handler");
        }

        docHandler += "&" + KewApiConstants.COMMAND_PARAMETER + "=" + docHandlerForm.getCommand();
        if (getUserSession(request).isBackdoorInUse()) {
            docHandler += "&" + KewApiConstants.BACKDOOR_ID_PARAMETER + "=" + getUserSession(request).getPrincipalName();
        }
        if (StringUtils.isNotBlank(request.getParameter(KRADConstants.RETURN_LOCATION_PARAMETER))) {
            docHandler += "&" + KRADConstants.RETURN_LOCATION_PARAMETER + "=" + request.getParameter(KRADConstants.RETURN_LOCATION_PARAMETER);
        }
        return new ActionForward(docHandler, true);
    }

    public static UserSession getUserSession(HttpServletRequest request) {
        return GlobalVariables.getUserSession();
    }
}
