/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.xmlrouting;

import java.util.Iterator;

import javax.xml.namespace.NamespaceContext;

/**
 * An XML NamespaceContext for KEW.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class WorkflowNamespaceContext implements NamespaceContext {
	@Override
    public String getNamespaceURI(String prefix) {
		if (prefix == null) {
			throw new IllegalArgumentException("The prefix cannot be null.");
		}

		if (prefix.equals("wf")) {
			return "http://nothingfornowwf.com";
		} else {
			return null;
		}
	}

	@Override
    public String getPrefix(String namespace) {
		if (namespace == null) {
			throw new IllegalArgumentException("The namespace uri cannot be null.");
		}
		if (namespace.equals("http://nothingfornowwf.com")) {
			return "wf";
		} else {
			return null;
		}
	}

	@Override
    public Iterator getPrefixes(String namespace) {
		return null;
	}
}
