/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.web;

import java.io.Serializable;
import java.util.Map;

import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.krad.util.ObjectUtils;

/**
 * A bean for the web-tier when represents the recipient of an Ad Hoc request.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AppSpecificRouteRecipient implements Serializable {

	private static final long serialVersionUID = 6587140192756322878L;

	private static Map actionRequestCds;
    protected String type;
    protected String actionRequested;
    protected String id;  //can be networkId or groupId (although, currently, it's being treated as principal name or group name)
    protected String namespaceCode; // Can be a group namespace code or a person name
    protected String actionRequestId; // The action request ID of the AdHoc route action that was sent for this app specific recipient, if any.

    public String getActionRequested() {
        return actionRequested;
    }
    public void setActionRequested(String actionRequested) {
        this.actionRequested = actionRequested;
    }
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }
    
    public String getNamespaceCode() {
    	return namespaceCode;
    }
    public void setNamespaceCode(String namespaceCode) {
    	this.namespaceCode = namespaceCode;
    }

    public String getActionRequestId() {
    	return actionRequestId;
    }

    public void setActionRequestId(String actionRequestId) {
    	this.actionRequestId = actionRequestId;
    }

    public String getActionRequestedValue(){
        if (ObjectUtils.isNull(actionRequestCds)) {
            actionRequestCds = CodeTranslator.arLabels;
        } else {
            actionRequestCds.clear();
            actionRequestCds.putAll(CodeTranslator.arLabels);
        }
        if(getActionRequested() != null && !getActionRequested().trim().equals("")){
            return (String) actionRequestCds.get(getActionRequested());
        }
        return null;
    }

}
