/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.options;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NamePrefixValuesFinder extends KeyValuesBase {

	private static final String PARAM_BO_CLASSNAME = PersonDocumentName.class.getSimpleName();

    @Override
	public List<KeyValue> getKeyValues() {

    	Collection<String> values = CoreFrameworkServiceLocator.getParameterService().getParameterValuesAsString(
                KimConstants.NAMESPACE_CODE, PARAM_BO_CLASSNAME, "PREFIXES"
        );
        List<KeyValue> labels = new ArrayList<KeyValue>();
        labels.add(new ConcreteKeyValue("", ""));
        for (String title : values) {
            labels.add(new ConcreteKeyValue(title, title));
            
        }

        return labels;
    }    

}
