/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.kuali.rice.kim.api.KimConstants;

@Entity
@Table(name = "KRIM_PND_GRP_MBR_T")
public class GroupDocumentMember extends KimDocumentBoActiveToFromBase {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "GRP_MBR_ID")
    protected String groupMemberId;

    @Column(name = "GRP_ID")
    protected String groupId;

    @Column(name = "MBR_ID")
    protected String memberId;

    @Column(name = "MBR_NM")
    protected String memberName;

    @Transient
    protected String memberNamespaceCode;

    @Transient
    protected String memberFullName;

    //TODO: remove the default                       
    @Column(name = "MBR_TYP_CD")
    protected String memberTypeCode = KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode();

    public String getGroupMemberId() {
        return this.groupMemberId;
    }

    public void setGroupMemberId(String groupMemberId) {
        this.groupMemberId = groupMemberId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    /**
	 * @return the memberId
	 */
    public String getMemberId() {
        return this.memberId;
    }

    /**
	 * @param memberId the memberId to set
	 */
    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    /**
	 * @return the memberTypeCode
	 */
    public String getMemberTypeCode() {
        return this.memberTypeCode;
    }

    /**
	 * @param memberTypeCode the memberTypeCode to set
	 */
    public void setMemberTypeCode(String memberTypeCode) {
        this.memberTypeCode = memberTypeCode;
    }

    /**
	 * @return the memberName
	 */
    public String getMemberName() {
        return this.memberName;
    }

    /**
	 * @param memberName the memberName to set
	 */
    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    /**
	 * @return the memberNamespaceCode
	 */
    public String getMemberNamespaceCode() {
        return this.memberNamespaceCode;
    }

    /**
	 * @param memberNamespaceCode the memberNamespaceCode to set
	 */
    public void setMemberNamespaceCode(String memberNamespaceCode) {
        this.memberNamespaceCode = memberNamespaceCode;
    }

    /**
	 * @return the memberFullName
	 */
    public String getMemberFullName() {
        return this.memberFullName;
    }

    /**
	 * @param memberFullName the memberFullName to set
	 */
    public void setMemberFullName(String memberFullName) {
        this.memberFullName = memberFullName;
    }
}
