/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.web.struts.action;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementGroupDocumentForm;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdentityManagementGroupInquiry extends IdentityManagementBaseInquiryAction {
	private static final Logger LOG = LogManager.getLogger(IdentityManagementGroupInquiry.class);

	@Override
	protected void loadKimObject(HttpServletRequest request, IdentityManagementDocumentFormBase form) {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm) form;
        String id = request.getParameter(KimConstants.PrimaryKeyConstants.GROUP_ID);
        String altId = request.getParameter(KimConstants.AttributeConstants.GROUP_ID);

        String groupId = StringUtils.isNotEmpty(id) ? id : altId;
        Group group = null;
        if (StringUtils.isNotEmpty(groupId)) {
        	group = KimApiServiceLocator.getGroupService().getGroup(groupId);
        } else {
        	String namespaceCode = request.getParameter(KimConstants.UniqueKeyConstants.NAMESPACE_CODE);
        	String groupName = request.getParameter(KimConstants.UniqueKeyConstants.GROUP_NAME);
        	
        	if (!StringUtils.isBlank(namespaceCode) && !StringUtils.isBlank(groupName)) {
        		group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
            }
        }
        if (group != null) {
        	getUiDocumentService().loadGroupDoc(groupDocumentForm.getGroupDocument(), group);
        } else {
        	LOG.error("No records found for Group Inquiry.");
            GlobalVariables.getMessageMap().putError(KRADConstants.GLOBAL_ERRORS, RiceKeyConstants.ERROR_INQUIRY);
        }
	}


    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {

        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm) form;

        ActionForward forward = super.execute(mapping, form, request, response);

        String previouslySortedColumnName = (String)GlobalVariables.getUserSession().retrieveObject(KimConstants.KimUIConstants.KIM_GROUP_INQUIRY_SORT_PREV_COL_NM);
        Boolean sortDescending = ((Boolean)GlobalVariables.getUserSession().retrieveObject(KimConstants.KimUIConstants.KIM_GROUP_INQUIRY_SORT_DESC_VALUE));

        KualiTableRenderFormMetadata memberTableMetadata =  groupDocumentForm.getMemberTableMetadata();
        memberTableMetadata.setPreviouslySortedColumnName(previouslySortedColumnName);
        if (sortDescending != null) {
            memberTableMetadata.setSortDescending(sortDescending.booleanValue());
        }
        if (groupDocumentForm.getMemberRows() != null) {
            memberTableMetadata.sort(groupDocumentForm.getMemberRows(), groupDocumentForm.getRecordsPerPage());
            memberTableMetadata.jumpToPage(memberTableMetadata.getSwitchToPageNumber(), groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
        }

        GlobalVariables.getUserSession().addObject(KimConstants.KimUIConstants.KIM_GROUP_INQUIRY_SORT_PREV_COL_NM, memberTableMetadata.getPreviouslySortedColumnName());
        GlobalVariables.getUserSession().addObject(KimConstants.KimUIConstants.KIM_GROUP_INQUIRY_SORT_DESC_VALUE, memberTableMetadata.isSortDescending());

        return forward;
    }


    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(RiceConstants.MAPPING_BASIC);
    }
}
