/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.web.struts.form;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.web.format.DateDisplayTimestampObjectFormatter;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;

import java.util.List;

public class IdentityManagementGroupDocumentForm extends IdentityManagementDocumentFormBase {
	protected static final long serialVersionUID = -107836689162363400L;
	
	{
		requiredNonEditableProperties.add("methodToCall");
	}
	
	protected boolean canAssignGroup = true;
	
	protected KimType kimType;
	protected GroupDocumentMember member = new GroupDocumentMember();
	protected String groupId;
    
	public IdentityManagementGroupDocumentForm() {
        super();
        setFormatterType("document.members.activeFromDate", DateDisplayTimestampObjectFormatter.class);
        setFormatterType("document.members.activeToDate", DateDisplayTimestampObjectFormatter.class);
    }

	@Override
	public String getDefaultDocumentTypeName(){
		return "IdentityManagementGroupDocument";
	}
	
	public IdentityManagementGroupDocument getGroupDocument() {
        return (IdentityManagementGroupDocument) this.getDocument();
    }

	public String getMemberLookupParameters(){
		if(member==null) {
			return "";
		}
		return getMemberLookupParameters(member.getMemberTypeCode());
	}

	public String getMemberFieldConversions(){
		if(member==null) {
			return "";
		}
		return getMemberFieldConversions(member.getMemberTypeCode());
	}

	public String getMemberBusinessObjectName(){
		if(member==null) {
			return "";
		}
		return getMemberBusinessObjectName(member.getMemberTypeCode());
	}

	protected String getMemberLookupParameters(String memberTypeCode){
		if(MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
			return "member.memberId:principalId,member.memberName:principalName";
		}
		else if(MemberType.ROLE.getCode().equals(memberTypeCode)) {
			return "member.memberId:id,member.memberName:name";
		}
		else if(MemberType.GROUP.getCode().equals(memberTypeCode)) {
			return "member.memberId:id,member.memberName:name,member.memberNamespaceCode:namespaceCode";
		}
		return "";
	}

	protected String getMemberFieldConversions(String memberTypeCode){
		if(MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
			return "principalId:member.memberId,principalName:member.memberName";
        }
		else if(MemberType.ROLE.getCode().equals(memberTypeCode)) {
			return "id:member.memberId,name:member.memberName";
        }
		else if(MemberType.GROUP.getCode().equals(memberTypeCode)) {
			return "id:member.memberId,name:member.memberName,namespaceCode:member.memberNamespaceCode";
        }
		return "";
	}

	protected String getMemberBusinessObjectName(String memberTypeCode){
		if(MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
			return PersonImpl.class.getName();
        }
		else if(MemberType.ROLE.getCode().equals(memberTypeCode)) {
			return RoleBo.class.getName();
        }
		else if(MemberType.GROUP.getCode().equals(memberTypeCode)) {
			return GroupBo.class.getName();
        }
		return "";
	}

	/**
	 * @return the kimType
	 */
	public KimType getKimType() {
		if(StringUtils.isNotBlank(getGroupDocument().getGroupTypeId())) {
			return KimApiServiceLocator.getKimTypeInfoService().getKimType(getGroupDocument().getGroupTypeId());
        }
		else {return kimType;}
	}

	public String getKimTypeClass(){
		return KimTypeBo.class.getName();
	}
	/**
	 * @return the canAssignGroup
	 */
	public boolean isCanAssignGroup() {
		return this.canAssignGroup;
	}

	/**
	 * @param canAssignGroup the canAssignGroup to set
	 */
	public void setCanAssignGroup(boolean canAssignGroup) {
		this.canAssignGroup = canAssignGroup;
	}

	/**
	 * @return the member
	 */
	public GroupDocumentMember getMember() {
		return this.member;
	}

	/**
	 * @param member the member to set
	 */
	public void setMember(GroupDocumentMember member) {
		this.member = member;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List getMemberRows() {
		return getGroupDocument().getMembers();
	}

	/**
	 * @return the groupId
	 */
	public String getGroupId() {
		return this.groupId;
	}

	/**
	 * @param groupId the groupId to set
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	/**
	 * @param kimType the kimType to set
	 */
	public void setKimType(KimType kimType) {
		this.kimType = kimType;
	}

}
