/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.deliverer;

import java.util.Collection;

import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.api.exception.MessageDismissalException;

/**
 * A NotificationMessageDeliverer interface specialization that should be implemented
 * by deliverers which can deliver messages in bulk.  This interface needs to exist
 * distinct from NotificationMessageDeliverer because processing in the two cases
 * will be different.  In the bulk case, the deliveries will be performed in a single
 * transaction.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BulkMessageDeliverer extends MessageDeliverer {
    /**
     * This method is responsible for delivering a series of messageDelivery records
     * @param messageDeliveries The messageDeliveries to process
     * @throws MessageDeliveryException
     */
    public void bulkDeliver(Collection<MessageDelivery> messageDeliveries) throws MessageDeliveryException;
    /**
     * This method is responsible for dismissing a series of messageDelivery records
     * @param messageDeliveries The messageDeliveries to process
     * @throws MessageDeliveryException
     */
    public void bulkDismiss(Collection<MessageDelivery> messageDeliveries) throws MessageDismissalException;
}
