/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.deliverer.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.api.exception.MessageDismissalException;

/**
 * A mock message deliverer that does nothing 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class MockMessageDeliverer implements MessageDeliverer {
    /**
     * Map of deliveries
     */
    private final Map<Long, MessageDelivery> deliveries = new HashMap<Long, MessageDelivery>();

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#deliver(org.kuali.rice.kcb.bo.MessageDelivery)
     */
    @Override
    public void deliver(MessageDelivery messageDelivery) throws MessageDeliveryException {
        deliveries.put(messageDelivery.getId(), messageDelivery);
    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#dismiss(org.kuali.rice.kcb.bo.MessageDelivery, java.lang.String, java.lang.String)
     */
    @Override
    public void dismiss(MessageDelivery messageDelivery, String user, String cause) throws MessageDismissalException {
        deliveries.remove(messageDelivery.getId());

    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#getDescription()
     */
    @Override
    public String getDescription() {
        return getName();
    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#getName()
     */
    @Override
    public String getName() {
        return "Mock";
    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#getPreferenceKeys()
     */
    @Override
    public LinkedHashMap<String, String> getPreferenceKeys() {
        // none for now
        return new LinkedHashMap<String, String>();
    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#getTitle()
     */
    @Override
    public String getTitle() {
        return getName();
    }

    /**
     * @see org.kuali.rice.kcb.deliverer.MessageDeliverer#validatePreferenceValues(java.util.HashMap)
     */
    @Override
    public void validatePreferenceValues(HashMap prefs) throws ErrorList {
        // no validation for now
    }
}
