/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.dao.impl;

import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.dao.NotificationMessegeDeliveryDao;
import org.kuali.rice.ken.util.NotificationConstants;
import org.kuali.rice.krad.data.DataObjectService;

import java.sql.Timestamp;
import java.util.Collection;

import static org.kuali.rice.core.api.criteria.PredicateFactory.*;

public class NotificationMessegeDeliveryDaoJpa implements NotificationMessegeDeliveryDao{

    @Override
    public Collection getUndeliveredMessageDelivers(DataObjectService dataObjectService) {

        //LOG.info("************************calling OJBNotificationMessegeDeliveryDao.getUndeliveredMessageDelivers************************ ");

        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(
                equal(NotificationConstants.BO_PROPERTY_NAMES.MESSAGE_DELIVERY_STATUS, NotificationConstants.MESSAGE_DELIVERY_STATUS.UNDELIVERED),
                isNull(NotificationConstants.BO_PROPERTY_NAMES.LOCKED_DATE)
        );

        return dataObjectService.findMatching(NotificationMessageDelivery.class, criteria.build()).getResults();
    }

    @Override
    public Collection<NotificationMessageDelivery> getMessageDeliveriesForAutoRemoval(Timestamp tm, DataObjectService dataObjectService) {

        //LOG.info("************************calling OJBNotificationMessegeDeliveryDao.getMessageDeliveriesForAutoRemoval************************ ");

        // get all UNDELIVERED/DELIVERED notification notification message delivery records with associated notifications that have and autoRemovalDateTime <= current
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(
            and(
                or(
                    equal(NotificationConstants.BO_PROPERTY_NAMES.MESSAGE_DELIVERY_STATUS, NotificationConstants.MESSAGE_DELIVERY_STATUS.DELIVERED),
                    equal(NotificationConstants.BO_PROPERTY_NAMES.MESSAGE_DELIVERY_STATUS, NotificationConstants.MESSAGE_DELIVERY_STATUS.UNDELIVERED)
                ),
                isNull(NotificationConstants.BO_PROPERTY_NAMES.LOCKED_DATE),
                lessThanOrEqual(NotificationConstants.BO_PROPERTY_NAMES.NOTIFICATION_AUTO_REMOVE_DATE_TIME, new Timestamp(System.currentTimeMillis()))
            )
        );

        Collection<NotificationMessageDelivery> messageDeliveries = dataObjectService.findMatching(NotificationMessageDelivery.class, criteria.build()).getResults();

        return messageDeliveries;
    }

    @Override
    public Collection<NotificationMessageDelivery> getLockedDeliveries(Class clazz, DataObjectService dataObjectService) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(isNotNull(NotificationConstants.BO_PROPERTY_NAMES.LOCKED_DATE));
        return dataObjectService.findMatching(clazz, criteria.build()).getResults();
    }


}
