/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist;

import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;
import org.kuali.rice.kew.actionitem.ActionItemBase;

import java.util.List;

/**
 * Implements the display tags paginated list to provide effecient paging for the action list.
 * This allows us not to have to fetch an entire action list each time a user pages their list.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PaginatedActionList implements PaginatedList {

	private final List<? extends ActionItemBase> list;
	private final int fullListSize;
	private final int pageNumber;
	private final int objectsPerPage;
	private final String searchId;
	private final String sortCriterion;
	private final SortOrderEnum sortDirection;

	public PaginatedActionList(List<? extends ActionItemBase> list, int fullListSize, int pageNumber, int objectsPerPage, String searchId, String sortCriterion, SortOrderEnum sortDirection) {
		this.list = list;
		this.fullListSize = fullListSize;
		this.pageNumber = pageNumber;
		this.objectsPerPage = objectsPerPage;
		this.searchId = searchId;
		this.sortCriterion = sortCriterion;
		this.sortDirection = sortDirection;
	}

	@Override
    public int getFullListSize() {
		return fullListSize;
	}

	@Override
    public List getList() {
		return list;
	}

	@Override
    public int getObjectsPerPage() {
		return objectsPerPage;
	}

	@Override
    public int getPageNumber() {
		return pageNumber;
	}

	@Override
    public String getSearchId() {
		return searchId;
	}

	@Override
    public String getSortCriterion() {
		return sortCriterion;
	}

	@Override
    public SortOrderEnum getSortDirection() {
		return sortDirection;
	}

}
