/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionrequest;

import org.kuali.rice.kim.api.group.Group;

/**
 * Represents an ActionRequest recipient who is a Group
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class KimGroupRecipient implements Recipient {

	private static final long serialVersionUID = 1L;
	private Group group;

	public KimGroupRecipient(String groupId) {
		this(ActionRequestFactory.getGroupService().getGroup(groupId));
	}

	public KimGroupRecipient(Group group) {
		if (group == null) {
			throw new IllegalArgumentException("Attempted to create a KimGroupRecipient with a null Group!");
		}
		this.group = group;
	}

	public Group getGroup() {
		return this.group;
	}

	public String getGroupId() {
		return getGroup().getId();
	}


}
