/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents the current Activation context of the workflow engine
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActivationContext implements Serializable {
    private static final long serialVersionUID = 5063689034941122774L;

    public static final boolean CONTEXT_IS_SIMULATION = true;

    boolean simulation = false;
    boolean activateRequests = false;
    List<ActionTakenValue> simulatedActionsTaken = new ArrayList<ActionTakenValue>();
    List<ActionItem> generatedActionItems = new ArrayList<ActionItem>();


	public ActivationContext(boolean simulation) {
		super();
		this.simulation = simulation;
	}

	public ActivationContext(boolean simulation, List<ActionTakenValue> simulatedActionsTaken) {
		super();
		this.simulation = simulation;
		this.simulatedActionsTaken = simulatedActionsTaken;
	}

    public boolean isActivateRequests() {
        return this.activateRequests;
    }

    public void setActivateRequests(boolean activateRequests) {
        this.activateRequests = activateRequests;
    }

    public List<ActionItem> getGeneratedActionItems() {
        return generatedActionItems;
    }

    public void setGeneratedActionItems(List<ActionItem> generatedActionItems) {
        this.generatedActionItems = generatedActionItems;
    }

    public List<ActionTakenValue> getSimulatedActionsTaken() {
        return simulatedActionsTaken;
    }

    public void setSimulatedActionsTaken(List<ActionTakenValue> simulatedActionsTaken) {
        this.simulatedActionsTaken = simulatedActionsTaken;
    }

    public boolean isSimulation() {
        return simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

}
