/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * Represents the current state of the workflow engine.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class EngineState implements Serializable {
    
	private static final long serialVersionUID = 2405363802483005090L;

	private static int currentSimulationId = -10;
    
    private RouteNodeInstance transitioningFrom;
    private RouteNodeInstance transitioningTo;
    private List<String> completeNodeInstances = new ArrayList<String>();
    private List<ActionRequestValue> generatedRequests = new ArrayList<ActionRequestValue>();
    
    public List<String> getCompleteNodeInstances() {
        return completeNodeInstances;
    }
    public void setCompleteNodeInstances(List<String> completeNodeInstances) {
        this.completeNodeInstances = completeNodeInstances;
    }
    public RouteNodeInstance getTransitioningFrom() {
        return transitioningFrom;
    }
    public void setTransitioningFrom(RouteNodeInstance transitioningFrom) {
        this.transitioningFrom = transitioningFrom;
    }
    public RouteNodeInstance getTransitioningTo() {
        return transitioningTo;
    }
    public void setTransitioningTo(RouteNodeInstance transitioningTo) {
        this.transitioningTo = transitioningTo;
    }
    public List<ActionRequestValue> getGeneratedRequests() {
        return generatedRequests;
    }
    public void setGeneratedRequests(List<ActionRequestValue> generatedRequests) {
        this.generatedRequests = generatedRequests;
    }
    
    /**
     * Gets the next id to be used for simulation purposes.  Since, during simulation, we cannot save to the database and get primary keys
     * assigned to our data beans, this method will be used to get a new simulation id which is guaranteed to be a negative number
     * which will be unique for at least the lifetime of the simulation.
     */
    public String getNextSimulationId() {
        synchronized (EngineState.class) {
            return String.valueOf(currentSimulationId--);
        }
    }
    
}
