/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

/**
 * A factory that constructs new Workflow Engines. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface WorkflowEngineFactory {

    /**
     * Constructs a new WorkflowEngine instance using the passed in orchestration
     * configuration. 
     * 
     * @return &lt;E&gt; a generic type that extends WorkflowEngine
     */
    public <E extends WorkflowEngine> E newEngine(OrchestrationConfig config);
    
}
