/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.feedback.web;

import org.kuali.rice.kns.web.struts.form.KualiForm;

/**
 * Struts ActionForm for {@link FeedbackAction}.
 *
 * @see FeedbackAction
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
/* Action Form for Feedback and Support Web form */
public class FeedbackForm extends KualiForm {

	private static final long serialVersionUID = -6881094307991817497L;
	/* Form elements */
    private String userName;
    private String userEmail;
    private String networkId;
    private String documentType;
    private String pageUrl;
    private String exception;
    private String timeDate;
    private String comments;
    private String documentId;
    private String firstName;
    private String lastName;
    private String phone;
    private String category;
    private String methodToCall = "";

    /**
     * @return Returns the category.
     */
    public String getCategory() {
        return category;
    }

    /**
     * @param category
     *            The category to set.
     */
    public void setCategory(String category) {
        this.category = category;
    }

    /* getters and setters */
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public String getNetworkId() {
        return networkId;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getException() {
        return exception;
    }

    public void setTimeDate(String timeDate) {
        this.timeDate = timeDate;
    }

    public String getTimeDate() {
        return timeDate;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getComments() {
        return comments;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentId() {
        return documentId;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return lastName;
    }

    /**
     * @return Returns the methodToCall.
     */
    @Override
    public String getMethodToCall() {
        return methodToCall;
    }

    /**
     * @param methodToCall
     *            The methodToCall to set.
     */
    @Override
    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}



}
