/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.action;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class ActionInvocationQueueAsyncCapableImpl implements ActionInvocationQueue {

    private final AsyncCapableService asyncCapableService;
    private final ActionInvocationQueue actionInvocationQueue;
    private final QName qname;
    private final String applicationId;

    ActionInvocationQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, ActionInvocationQueue actionInvocationQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (actionInvocationQueue == null) {
            throw new IllegalArgumentException("actionInvocationQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.actionInvocationQueue = actionInvocationQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void invokeAction(String principalId, String documentId, ActionInvocation actionInvocation) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, principalId + "/" + documentId, actionInvocation != null ? actionInvocation.toString() : null,
                new CallMetadata("invokeAction", new Class[]{String.class, String.class, ActionInvocation.class }, new Object[]{principalId, documentId, actionInvocation}),
                () -> actionInvocationQueue.invokeAction(principalId, documentId, actionInvocation));
    }
}
