/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.action;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class RolePokerQueueAsyncCapableImpl implements RolePokerQueue {

    private final AsyncCapableService asyncCapableService;
    private final RolePokerQueue rolePokerQueue;
    private final QName qname;
    private final String applicationId;

    RolePokerQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, RolePokerQueue rolePokerQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (rolePokerQueue == null) {
            throw new IllegalArgumentException("rolePokerQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.rolePokerQueue = rolePokerQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void reResolveRole(String documentId, String roleName) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, roleName, new CallMetadata("reResolveRole", new Class[]{String.class, String.class}, new Object[]{documentId, roleName}),
                () -> rolePokerQueue.reResolveRole(documentId, roleName));

    }

    @Override
    public void reResolveQualifiedRole(String documentId, String roleName, String qualifiedRoleNameLabel) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, roleName + "/" + qualifiedRoleNameLabel,
                new CallMetadata("reResolveQualifiedRole", new Class[]{String.class, String.class, String.class }, new Object[]{documentId, roleName, qualifiedRoleNameLabel}),
                () -> rolePokerQueue.reResolveQualifiedRole(documentId, roleName, qualifiedRoleNameLabel));
    }
}
