/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail.service;

import java.util.Collection;

import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.feedback.web.FeedbackForm;
import org.kuali.rice.kim.api.identity.Person;

/**
 * Interface for generating email message content for various types of messages the system needs to send
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see EmailContent
 */
public interface EmailContentService {
    public EmailContent generateImmediateReminder(Person person, ActionItem actionItem, DocumentType documentType);
    public EmailContent generateDailyReminder(Person person, Collection<ActionItem> actionItems);
    public EmailContent generateWeeklyReminder(Person person, Collection<ActionItem> actionItems);
    public EmailContent generateFeedback(FeedbackForm form);

    /* these are more or less helper utilities and probably should live in some core helper class */
    public String getDocumentTypeEmailAddress(DocumentType documentType);
    public String getApplicationEmailAddress();
}
