/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.preferences.web;

import java.util.ArrayList;
import java.util.List;

 
public class PreferencesConstants {

    public static final class EmailNotificationPreferences {
        public static final String NONE = "no";
        public static final String DAILY= "daily";
        public static final String WEEKLY= "weekly";
        public static final String IMMEDIATE = "immediate";

        public static List<String> getEmailNotificationPreferences(){
            List<String> emailNotifications = new ArrayList<String>();
            emailNotifications.add(NONE);
            emailNotifications.add(DAILY);
            emailNotifications.add(WEEKLY);
            emailNotifications.add(IMMEDIATE);
            return emailNotifications;
        }
    }

    public static class DelegatorFilterValues {
	    public static final String SECONDARY_DELEGATORS_ONLY_ON_FILTER_PAGE = "Secondary Delegators only on Filter Page";
	    public static final String SECONDARY_DELEGATORS_ON_ACTION_LIST_PAGE = "Secondary Delegators on Action List Page";
	
	    public static List<String> getDelegatorFilterValues() {
		    List<String> delegatorFilterValues = new ArrayList<String>();
		    delegatorFilterValues.add(SECONDARY_DELEGATORS_ONLY_ON_FILTER_PAGE);
		    delegatorFilterValues.add(SECONDARY_DELEGATORS_ON_ACTION_LIST_PAGE);
		    return delegatorFilterValues;
	    }
    }

    public static class PrimaryDelegateFilterValues {
	    public static final String PRIMARY_DELEGATES_ONLY_ON_FILTER_VALUES = "Primary Delegates only on Filter Page";
	    public static final String PRIMARY_DELEGATES_ON_ACTION_LIST_PAGE = "Primary Delegates on Action List Page";

	    public static List<String> getPrimaryDelegateFilterValues() {
		    List<String> primaryDelegateFilterValues = new ArrayList<String>();
		    primaryDelegateFilterValues.add(PRIMARY_DELEGATES_ONLY_ON_FILTER_VALUES);
		    primaryDelegateFilterValues.add(PRIMARY_DELEGATES_ON_ACTION_LIST_PAGE);
		    return primaryDelegateFilterValues;
	    }
    }

    public static class CheckBoxValues {
    	public static final String YES = "yes";
	    public static final String NO = "no";
	
	    public static List<String> getCheckBoxValues() {
		    List<String> checkboxValues = new ArrayList<String>();
    		checkboxValues.add(YES);
	    	checkboxValues.add(NO);
		    return checkboxValues;
	    }
    }

    public static class PreferencesDocumentRouteStatusColors {
	    public static final String ORANGE = "orange";
	    public static final String RED = "red";
	    public static final String PURPLE = "purple";
	    public static final String BLUE = "blue";
	    public static final String GREEN = "green";
	    public static final String SLATE = "slate";
	    public static final String WHITE = "white";
	    public static final String PINK = "pink";
	    public static final String YELLOW = "yellow";
	    public static final String AQUA = "aqua";
	    public static final String TAN = "tan";
	
    	public static List<String> getPreferencesDocumentRouteStatusColors() {
	    	List<String> colors = new ArrayList<String>();
		    colors.add(ORANGE);
		    colors.add(RED);
		    colors.add(PURPLE);
		    colors.add(BLUE);
		    colors.add(GREEN);
		    colors.add(SLATE);
		    colors.add(WHITE);
		    colors.add(PINK);
		    colors.add(YELLOW);
		    colors.add(AQUA);
		    colors.add(TAN);
		    return colors;
	    }
    }
}
