/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.quicklinks;

import org.kuali.rice.kew.doctype.bo.DocumentType;

/**
 * Stores statistics about the number of times a particular {@link DocumentType}
 * appears in a particular user's Action List.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionListStats implements Comparable<ActionListStats> {

    private String documentTypeName;
    private String documentTypeLabelText;
    private int count;

    public ActionListStats(String documentTypeName, String documentTypeLabelText, int count) {
        this.documentTypeName = documentTypeName;
        this.documentTypeLabelText = documentTypeLabelText;
        this.count = count;
    }
    
    public String getDocumentTypeLabelText() {
        return documentTypeLabelText;
    }
    public void setDocumentTypeLabelText(String documentTypeLabelText) {
        this.documentTypeLabelText = documentTypeLabelText;
    }
    public String getDocumentTypeName() {
        return documentTypeName;
    }
    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }
    public int getCount() {
        return count;
    }
    public void setCount(int count) {
        this.count = count;
    }
    public String getActionListFilterUrl() {
        return "ActionList.do?method=showRequestFilteredView&docType=" + documentTypeName;
    }
    
    @Override
    public int compareTo(ActionListStats obj) {
        if (obj != null) {
            return this.documentTypeLabelText.compareTo(obj.documentTypeLabelText);
        }
        return 0;
    }
}
