/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.service;

import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.springframework.cache.annotation.CacheEvict;

import java.util.List;
import java.util.Map;

public interface UiDocumentService {
	/**
	 * 
	 * This method to populate Entity tables from person document pending tables when it is approved.
	 *
	 */
    @CacheEvict(value={Entity.Cache.NAME, EntityDefault.Cache.NAME, Principal.Cache.NAME, Role.Cache.NAME, GroupMember.Cache.NAME, RoleMember.Cache.NAME}, allEntries = true)
    void saveEntityPerson(IdentityManagementPersonDocument identityManagementPersonDocument);
    
    /**
     * 
     * This method is to set up the DD attribute entry map for role qualifiers, so it can be rendered.
     *
     */
    Map<String,Object> getAttributeEntries( List<KimAttributeField> definitions );
	/**
	 * 
	 * This method is to load identity to person document pending Bos when user 'initiate' a document for 'editing' identity.
	 *
	 */
	void loadEntityToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId);

	/**
	 * 
	 * This method loads a role document
	 */
	void loadRoleDoc(IdentityManagementRoleDocument identityManagementRoleDocument, Role kimRole);

    /**
     *
     * This method loads a role document members based on search criteria
     *
     */
    void loadRoleMembersBasedOnSearch(IdentityManagementRoleDocument identityManagementRoleDocument,
                                             String memberSearchValue);

    /**
     *
     * This method loads a document's original role members
     *
     */
    void clearRestrictedRoleMembersSearchResults(IdentityManagementRoleDocument identityManagementRoleDocument);


    @CacheEvict(value={Role.Cache.NAME, RoleMember.Cache.NAME, Permission.Cache.NAME}, allEntries = true)
	void saveRole(IdentityManagementRoleDocument identityManagementRoleDocument);


	/**
	 * This method loads a role document
	 */
	void loadGroupDoc(IdentityManagementGroupDocument identityManagementGroupDocument, Group kimGroup);

    @CacheEvict(value={Group.Cache.NAME,GroupMember.Cache.NAME, Role.Cache.NAME}, allEntries = true)
	void saveGroup(IdentityManagementGroupDocument identityManagementGroupDocument);

	Object getMember(MemberType memberType, String memberId);
	
	String getMemberName(MemberType memberType, String memberId);
	
	String getMemberNamespaceCode(MemberType memberType, String memberId);

	String getMemberName(MemberType memberType, Object member);
	
	String getMemberNamespaceCode(MemberType memberType, Object member);

	List<RoleResponsibilityActionBo> getRoleMemberResponsibilityActionImpls(String roleMemberId);
	
	List<DelegateTypeBo> getRoleDelegations(String roleId);
	
	String getMemberIdByName(MemberType memberType, String memberNamespaceCode, String memberName);

	void setDelegationMembersInDocument(IdentityManagementRoleDocument identityManagementRoleDocument);

    void setMembersInDocument(IdentityManagementRoleDocument identityManagementRoleDocument);

    RoleMemberBo getRoleMember(String roleMemberId);
	
	List<KimDocumentRoleMember> getRoleMembers(Map<String,String> fieldValues);
	
	boolean canModifyEntity( String currentUserPrincipalId, String toModifyPrincipalId );
	boolean canOverrideEntityPrivacyPreferences( String currentUserPrincipalId, String toModifyPrincipalId );

	List<EntityEmployment> getEntityEmploymentInformationInfo(String entityId);
}
