/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.kew.actionlist.ActionListForm;

public class UserWorkgroupsKeyValues extends UifKeyValuesFinderBase {

    private boolean blankOption;


    @Override
    public List<KeyValue> getKeyValues(ViewModel model) {
        ActionListForm actionListForm = (ActionListForm)model;
        List<String> userWorkgroups =
                KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(actionListForm.getUser());

        //note that userWorkgroups is unmodifiable so we need to create a new list that we can sort
        List<String> userGroupsToSort = new ArrayList<String>(userWorkgroups);

        List<KeyValue> sortedUserWorkgroups = new ArrayList<KeyValue>();
        KeyValue keyValue = null;
        keyValue = new ConcreteKeyValue(KewApiConstants.NO_FILTERING, KewApiConstants.NO_FILTERING);
        sortedUserWorkgroups.add(keyValue);

        if (userGroupsToSort != null && userGroupsToSort.size() > 0) {
            Collections.sort(userGroupsToSort);
            Group group;

            for (String groupId : userGroupsToSort)
            {
                group = KimApiServiceLocator.getGroupService().getGroup(groupId);
                keyValue = new ConcreteKeyValue(groupId, group.getName());
                sortedUserWorkgroups.add(keyValue);
            }
        }

        return sortedUserWorkgroups;
    }

    /**
     * @return the blankOption
     */
    public boolean isBlankOption() {
        return this.blankOption;
    }

    /**
     * @param blankOption the blankOption to set
     */
    public void setBlankOption(boolean blankOption) {
        this.blankOption = blankOption;
    }

//    private List<? extends KeyValue> getUserWorkgroupsDropDownList(String principalId) {
//        List<String> userWorkgroups =
//                KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
//
//        //note that userWorkgroups is unmodifiable so we need to create a new list that we can sort
//        List<String> userGroupsToSort = new ArrayList<String>(userWorkgroups);
//
//        List<KeyValue> sortedUserWorkgroups = new ArrayList<KeyValue>();
//        KeyValue keyValue = null;
//        keyValue = new ConcreteKeyValue(KewApiConstants.NO_FILTERING, KewApiConstants.NO_FILTERING);
//        sortedUserWorkgroups.add(keyValue);
//        if (userGroupsToSort != null && userGroupsToSort.size() > 0) {
//            Collections.sort(userGroupsToSort);
//
//            Group group;
//            for (String groupId : userGroupsToSort)
//            {
//                group = KimApiServiceLocator.getGroupService().getGroup(groupId);
//                keyValue = new ConcreteKeyValue(groupId, group.getName());
//                sortedUserWorkgroups.add(keyValue);
//            }
//        }
//        return sortedUserWorkgroups;
//    }


}
