/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionrequest.bo;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A values finder for returning KEW Action Request codes.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionRequestCodeValuesFinder extends KeyValuesBase {

	private static final List<KeyValue> ACTION_REQUEST_CODES;
	static {
		final List<KeyValue> temp = new ArrayList<KeyValue>();
		for (String actionRequestCode : KewApiConstants.ACTION_REQUEST_CODES.keySet()) {
			temp.add(new ConcreteKeyValue(actionRequestCode, KewApiConstants.ACTION_REQUEST_CODES.get(actionRequestCode)));
		}
		
		ACTION_REQUEST_CODES = Collections.unmodifiableList(temp);
	}

	@Override
	public List<KeyValue> getKeyValues() {
		return ACTION_REQUEST_CODES;
	}

}
