/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var.schemes;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;

/**
 * A property scheme that just returns the literal value of the locator portion.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class LiteralScheme implements PropertyScheme {
    @Override
    public String getName() {
        return "literal";
    }
    @Override
    public String getShortName() {
        return "lit";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        // just returns the literal text
        return property.locator;
    }

    @Override
    public String toString() {
        return "[LiteralScheme]";
    }
}
