/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail;

import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;


/**
 * A class which has some convenience methods for handling Emails and stylesheets. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class EmailStyleHelper {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(EmailStyleHelper.class);
    
    public EmailContent generateEmailContent(Templates style, Document document) {
	DOMResult result = new DOMResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input document: " + XmlJotter.jotNode(document.getDocumentElement(), true));
        }
        try {
            style.newTransformer().transform(new DOMSource(document), result);
        } catch (TransformerException te) {
            String message = "Error transforming immediate reminder DOM";
            LOG.error(message, te);
            throw new WorkflowRuntimeException(message, te);
        }

        Node node = result.getNode();

        if (LOG.isDebugEnabled()) {
            LOG.debug("Email to be sent: " + XmlJotter.jotNode(node));
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        try {
            String subject = (String) xpath.evaluate("/email/subject", node, XPathConstants.STRING);
            String body = (String) xpath.evaluate("/email/body", node, XPathConstants.STRING);
            // simple heuristic to determine whether content is HTML
            return new EmailContent(subject, body, body.matches("(?msi).*<(\\w+:)?html.*"));
        } catch (XPathExpressionException xpee) {
            throw new WorkflowRuntimeException("Error evaluating generated email content", xpee);
        }
    }

}
