/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.web.spring;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.KENIntegrationService;
import org.kuali.rice.kcb.service.MessageDelivererRegistryService;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kns.util.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/kcb"})
@Controller(value="prefsController")
public class UserPreferencesController {
    private static final Logger LOG = LogManager.getLogger(UserPreferencesController.class);
    private static final String VIEW = "DelivererPreferences";
    @Autowired
    @Qualifier(value="recipientPreferenceService")
    protected RecipientPreferenceService recipientPreferenceService;
    @Autowired
    @Qualifier(value="messageDelivererRegistryService")
    protected MessageDelivererRegistryService messageDelivererRegistryService;
    @Autowired
    @Qualifier(value="kenIntegrationService")
    protected KENIntegrationService kenIntegrationService;

    protected Collection<String> getAllChannels() {
        ArrayList<String> allChannels = new ArrayList<String>();
        allChannels.addAll(this.kenIntegrationService.getAllChannelNames());
        return allChannels;
    }

    @RequestMapping(value={"/prefs.kcb"})
    public ModelAndView displayDelivererConfigurationForm(HttpServletRequest request) {
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        Collection<MessageDeliverer> deliveryTypes = this.messageDelivererRegistryService.getAllDeliverers();
        Collection<String> channels = this.getAllChannels();
        HashMap<String, String> preferences = this.recipientPreferenceService.getRecipientPreferences(userid);
        Collection<RecipientDelivererConfig> currentDeliverers = this.recipientPreferenceService.getDeliverersForRecipient(userid);
        HashMap<CallSite, Boolean> currentDeliverersMap = new HashMap<CallSite, Boolean>();
        for (RecipientDelivererConfig udc : currentDeliverers) {
            String channelName = udc.getChannel();
            currentDeliverersMap.put((CallSite)((Object)(udc.getDelivererName() + "." + channelName)), Boolean.TRUE);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("deliveryTypes", deliveryTypes);
        model.put("preferences", preferences);
        model.put("currentDeliverersMap", currentDeliverersMap);
        this.putBackLocation(model, request.getParameter("backLocation"));
        return new ModelAndView(VIEW, model);
    }

    private void putBackLocation(Map<String, Object> model, String backLocation) {
        if (StringUtils.isNotBlank((String)backLocation)) {
            model.put("backLocation", WebUtils.sanitizeBackLocation((String)backLocation));
        }
    }

    @RequestMapping(value={"/saveprefs.kcb"})
    public ModelAndView saveDelivererConfiguration(HttpServletRequest request) {
        String userid = request.getRemoteUser();
        LOG.debug("remoteUser: " + userid);
        boolean error = false;
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap<CallSite, String> preferences = new HashMap<CallSite, String>();
        Collection<MessageDeliverer> deliveryTypes = this.messageDelivererRegistryService.getAllDeliverers();
        this.recipientPreferenceService.removeRecipientDelivererConfigs(userid);
        for (MessageDeliverer dt : deliveryTypes) {
            String deliveryTypeName = dt.getName();
            LinkedHashMap<String, String> prefMap = dt.getPreferenceKeys();
            LOG.debug("deliveryName: " + deliveryTypeName);
            HashMap<String, String> userprefs = new HashMap<String, String>();
            for (String prefKey : ((HashMap)prefMap).keySet()) {
                LOG.debug("   key: " + prefKey + ", value: " + request.getParameter(deliveryTypeName + "." + prefKey));
                userprefs.put(deliveryTypeName + "." + prefKey, request.getParameter(deliveryTypeName + "." + prefKey));
                preferences.put((CallSite)((Object)(deliveryTypeName + "." + prefKey)), request.getParameter(deliveryTypeName + "." + prefKey));
            }
            try {
                this.recipientPreferenceService.saveRecipientPreferences(userid, userprefs, dt);
            }
            catch (ErrorList errorlist) {
                error = true;
                model.put("errorList", errorlist.getErrors());
            }
            String[] channels = request.getParameterValues(deliveryTypeName + ".channels");
            if (channels != null && channels.length > 0) {
                for (int j = 0; j < channels.length; ++j) {
                    LOG.debug(deliveryTypeName + ".channels[" + j + "] " + channels[j]);
                }
            }
            this.recipientPreferenceService.saveRecipientDelivererConfig(userid, deliveryTypeName, channels);
        }
        Collection<String> channels = this.getAllChannels();
        Collection<RecipientDelivererConfig> currentDeliverers = this.recipientPreferenceService.getDeliverersForRecipient(userid);
        HashMap<CallSite, Boolean> currentDeliverersMap = new HashMap<CallSite, Boolean>();
        for (RecipientDelivererConfig udc : currentDeliverers) {
            String channelId = udc.getChannel();
            currentDeliverersMap.put((CallSite)((Object)(udc.getDelivererName() + "." + channelId)), Boolean.TRUE);
        }
        model.put("channels", channels);
        model.put("deliveryTypes", deliveryTypes);
        model.put("preferences", preferences);
        model.put("currentDeliverersMap", currentDeliverersMap);
        model.put("message", "Update Successful");
        this.putBackLocation(model, request.getParameter("backLocation"));
        return new ModelAndView(VIEW, model);
    }

    public RecipientPreferenceService getRecipientPreferenceService() {
        return this.recipientPreferenceService;
    }

    public MessageDelivererRegistryService getMessageDelivererRegistryService() {
        return this.messageDelivererRegistryService;
    }

    public KENIntegrationService getKenIntegrationService() {
        return this.kenIntegrationService;
    }

    public void setRecipientPreferenceService(RecipientPreferenceService userPreferenceService) {
        this.recipientPreferenceService = userPreferenceService;
    }

    public void setMessageDelivererRegistryService(MessageDelivererRegistryService messageDelivererRegistryService) {
        this.messageDelivererRegistryService = messageDelivererRegistryService;
    }

    public void setKenIntegrationService(KENIntegrationService kis) {
        this.kenIntegrationService = kis;
    }
}

