/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompoundEntityResolver
implements EntityResolver {
    private static final Logger LOG = LogManager.getLogger(CompoundEntityResolver.class);
    private final List<EntityResolver> resolvers;

    public CompoundEntityResolver(EntityResolver first, EntityResolver second) {
        this.resolvers = new ArrayList<EntityResolver>(2);
        this.resolvers.add(first);
        this.resolvers.add(second);
    }

    public CompoundEntityResolver(List<EntityResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("resolveEntity: " + publicId + " " + systemId);
        for (EntityResolver resolver : this.resolvers) {
            LOG.debug("Invoking entity resolver: " + String.valueOf(resolver));
            InputSource source = resolver.resolveEntity(publicId, systemId);
            if (source == null) continue;
            LOG.debug("source != null: " + String.valueOf(source));
            return source;
        }
        return null;
    }
}

