/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.impl.DocumentTypePermissionServiceImpl;
import org.kuali.rice.kew.doctype.service.impl.KimDocumentTypeAuthorizer;
import org.kuali.rice.kew.framework.document.security.AuthorizableAction;
import org.kuali.rice.kew.framework.document.security.DocumentTypeAuthorizer;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class DocumentTypePermissionServiceAuthorizerImpl
extends DocumentTypePermissionServiceImpl {
    private static final Logger LOG = LogManager.getLogger(DocumentTypePermissionServiceAuthorizerImpl.class);
    private static final String PLACEHOLDER_EXTENSION_NAME = "DocumenTypeAuthorizer";
    private static final String PLACEHOLDER_EXTENSION_TYPE = "DocumenTypeAuthorizer";
    protected DocumentTypeAuthorizer defaultDocumentTypeAuthorizer = new KimDocumentTypeAuthorizer();

    protected DocumentTypeAuthorizer getDocumentTypeAuthorizer(DocumentType documentType) {
        DocumentTypeAuthorizer delegate = this.defaultDocumentTypeAuthorizer;
        if (documentType == null) {
            LOG.warn("DocumentType is null, using default DocumentTypeAuthorizer impl: " + String.valueOf(delegate.getClass()));
        } else {
            String documentTypeAuthorizer = documentType.getAuthorizer();
            if (StringUtils.isNotBlank((String)documentTypeAuthorizer)) {
                ExtensionDefinition extensionDef = ExtensionDefinition.Builder.create((String)"DocumenTypeAuthorizer", (String)"DocumenTypeAuthorizer", (String)documentTypeAuthorizer).build();
                Object extension = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDef);
                if (extension == null) {
                    throw new WorkflowRuntimeException("Could not load DocumentTypeAuthorizer: " + documentTypeAuthorizer);
                }
                if (!DocumentTypeAuthorizer.class.isAssignableFrom(extension.getClass())) {
                    throw new WorkflowRuntimeException("DocumentType Authorizer '" + documentTypeAuthorizer + "' configured for document type '" + documentType.getName() + " does not implement " + DocumentTypeAuthorizer.class.getName());
                }
                delegate = (DocumentTypeAuthorizer)extension;
            }
        }
        return delegate;
    }

    @Override
    public boolean canInitiate(String principalId, DocumentType documentType) {
        return this.getDocumentTypeAuthorizer(documentType).isActionAuthorized(new AuthorizableAction(AuthorizableAction.CheckType.INITIATION), principalId, DocumentType.Builder.create((DocumentTypeContract)documentType).build(), null, Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canBlanketApprove(String principalId, DocumentRouteHeaderValue document) {
        this.validateDocument(document);
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.BLANKET_APPROVE), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canCancel(String principalId, DocumentRouteHeaderValue document) {
        this.validateDocument(document);
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.CANCEL), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canRecall(String principalId, DocumentRouteHeaderValue document) {
        this.validateDocument(document);
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.RECALL), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canReturnToPreviousRouteNode(String principalId, DocumentRouteHeaderValue document) {
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.RETURN_TO_PREVIOUS), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canSave(String principalId, DocumentRouteHeaderValue document) {
        this.validateDocument(document);
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.SAVE), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canRoute(String principalId, DocumentRouteHeaderValue document) {
        this.validateDocument(document);
        return this.getDocumentTypeAuthorizer(document.getDocumentType()).isActionAuthorized(new AuthorizableAction(ActionType.ROUTE), principalId, DocumentType.Builder.create((DocumentTypeContract)document.getDocumentType()).build(), Document.Builder.create((DocumentContract)document).build(), Collections.EMPTY_MAP).isAuthorized();
    }

    @Override
    public boolean canSuperUserApproveDocument(String principalId, DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        HashMap<DocumentTypeAuthorizer.ActionArgument, Object> actionParams = new HashMap<DocumentTypeAuthorizer.ActionArgument, Object>();
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES, routeNodeNames);
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS, routeStatusCode);
        return this.getDocumentTypeAuthorizer(documentType).isActionAuthorized(new AuthorizableAction(ActionType.SU_APPROVE), principalId, DocumentType.Builder.create((DocumentTypeContract)documentType).build(), null, actionParams).isAuthorized();
    }

    @Override
    public boolean canSuperUserDisapproveDocument(String principalId, DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        HashMap<DocumentTypeAuthorizer.ActionArgument, Object> actionParams = new HashMap<DocumentTypeAuthorizer.ActionArgument, Object>();
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES, routeNodeNames);
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS, routeStatusCode);
        return this.getDocumentTypeAuthorizer(documentType).isActionAuthorized(new AuthorizableAction(ActionType.SU_DISAPPROVE), principalId, DocumentType.Builder.create((DocumentTypeContract)documentType).build(), null, actionParams).isAuthorized();
    }

    @Override
    protected boolean canSuperUserApproveSingleActionRequest(String principalId, DocumentType documentType, Collection<String> routeNodeNames, String routeStatusCode) {
        HashMap<DocumentTypeAuthorizer.ActionArgument, Object> actionParams = new HashMap<DocumentTypeAuthorizer.ActionArgument, Object>();
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES, routeNodeNames);
        actionParams.put(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS, routeStatusCode);
        return this.getDocumentTypeAuthorizer(documentType).isActionAuthorized(new AuthorizableAction(AuthorizableAction.CheckType.SU_APPROVE_ACTION_REQUEST), principalId, DocumentType.Builder.create((DocumentTypeContract)documentType).build(), null, actionParams).isAuthorized();
    }
}

