/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.EngineState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;

public class RouteContext
implements Serializable {
    private static final long serialVersionUID = -7125137491367944594L;
    private String id = "";
    private DocumentRouteHeaderValue routeHeader;
    private DocumentContent documentContent;
    private RouteNodeInstance nodeInstance;
    private EngineState engineState;
    private ActionRequestValue actionRequest;
    private ActivationContext activationContext = new ActivationContext(false);
    private boolean doNotSendApproveNotificationEmails = false;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private boolean searchIndexingRequestedForContext = false;
    private static final ThreadLocal<List<RouteContext>> ROUTE_CONTEXT_STACK = ThreadLocal.withInitial(() -> {
        LinkedList<RouteContext> contextStack = new LinkedList<RouteContext>();
        contextStack.add(0, new RouteContext());
        return contextStack;
    });

    public static RouteContext getCurrentRouteContext() {
        return ROUTE_CONTEXT_STACK.get().get(0);
    }

    public static void clearRouteContextByDocumentId(String documentId) {
        if (StringUtils.isNotBlank((CharSequence)documentId)) {
            for (int i = 0; i < ROUTE_CONTEXT_STACK.get().size(); ++i) {
                if (!RouteContext.ROUTE_CONTEXT_STACK.get().get((int)i).routeHeader.getDocumentId().equals(documentId)) continue;
                ROUTE_CONTEXT_STACK.get().remove(i);
                ROUTE_CONTEXT_STACK.get().add(i, new RouteContext());
            }
        }
    }

    public static void clearCurrentRouteContext() {
        ROUTE_CONTEXT_STACK.get().remove(0);
        ROUTE_CONTEXT_STACK.get().add(0, new RouteContext());
    }

    public static RouteContext createNewRouteContext() {
        ROUTE_CONTEXT_STACK.get().add(0, new RouteContext());
        return RouteContext.getCurrentRouteContext();
    }

    public static RouteContext releaseCurrentRouteContext() {
        return ROUTE_CONTEXT_STACK.get().remove(0);
    }

    @Deprecated
    public DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    @Deprecated
    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    public DocumentRouteHeaderValue getDocument() {
        return this.routeHeader;
    }

    public void setDocument(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
        try {
            this.setDocumentContent(new StandardDocumentContent(routeHeader.getDocContent(), this));
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public DocumentContent getDocumentContent() {
        return this.documentContent;
    }

    public void setDocumentContent(DocumentContent documentContent) {
        this.documentContent = documentContent;
    }

    public RouteNodeInstance getNodeInstance() {
        return this.nodeInstance;
    }

    public void setNodeInstance(RouteNodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
    }

    public EngineState getEngineState() {
        return this.engineState;
    }

    public void setEngineState(EngineState engineState) {
        this.engineState = engineState;
    }

    public ActionRequestValue getActionRequest() {
        return this.actionRequest;
    }

    public void setActionRequest(ActionRequestValue actionRequest) {
        this.actionRequest = actionRequest;
    }

    public boolean isSimulation() {
        if (this.activationContext == null) {
            return false;
        }
        return this.activationContext.isSimulation();
    }

    public ActivationContext getActivationContext() {
        return this.activationContext;
    }

    public void setActivationContext(ActivationContext activationContext) {
        this.activationContext = activationContext;
    }

    public boolean isDoNotSendApproveNotificationEmails() {
        return this.doNotSendApproveNotificationEmails;
    }

    public void setDoNotSendApproveNotificationEmails(boolean sendNotificationEmails) {
        this.doNotSendApproveNotificationEmails = sendNotificationEmails;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean isSearchIndexingRequestedForContext() {
        return this.searchIndexingRequestedForContext;
    }

    public void requestSearchIndexingForContext() {
        this.searchIndexingRequestedForContext = true;
    }
}

