/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RequestActivationNodeBase;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.Utilities;

public class RequestActivationNode
extends RequestActivationNodeBase {
    private static final Logger LOG = LogManager.getLogger(RequestActivationNode.class);
    private static long generatedRequestPriority = 0L;

    @Override
    public SimpleResult process(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
        DocumentRouteHeaderValue document = routeContext.getDocument();
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        if (routeContext.isSimulation()) {
            if (routeContext.getActivationContext().isActivateRequests()) {
                this.activateRequests(routeContext, document, nodeInstance);
            }
            return new SimpleResult(true);
        }
        if (!this.activateRequests(routeContext, document, nodeInstance) && this.shouldTransition(document, nodeInstance)) {
            return new SimpleResult(true);
        }
        return new SimpleResult(false);
    }

    protected boolean shouldTransition(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        List<ActionRequestValue> requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        boolean shouldTransition = true;
        for (ActionRequestValue request : requests) {
            if (!request.isApproveOrCompleteRequest()) continue;
            shouldTransition = false;
            break;
        }
        return shouldTransition;
    }

    public boolean activateRequests(RouteContext context, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) throws WorkflowException {
        ThreadContext.put((String)"docId", (String)document.getDocumentId());
        PerformanceLogger performanceLogger = new PerformanceLogger(document.getDocumentId());
        ArrayList<ActionItem> generatedActionItems = new ArrayList<ActionItem>();
        List<Object> requests = new ArrayList();
        if (context.isSimulation()) {
            for (ActionRequestValue ar : context.getDocument().getActionRequests()) {
                if (!ar.getCurrentIndicator().booleanValue() || !ActionRequestStatus.INITIALIZED.getCode().equals(ar.getStatus()) && !ActionRequestStatus.ACTIVATED.getCode().equals(ar.getStatus()) || !ar.getNodeInstance().getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId()) || ar.getParentActionRequest() != null) continue;
                requests.add(ar);
            }
            requests.addAll(context.getEngineState().getGeneratedRequests());
        } else {
            requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pending Root Requests " + requests.size());
        }
        boolean activatedApproveRequest = this.activateRequestsCustom(context, requests, generatedActionItems, document, nodeInstance);
        this.notify(context, generatedActionItems, nodeInstance);
        performanceLogger.log("Time to activate requests.");
        return activatedApproveRequest;
    }

    protected boolean activateRequestsCustom(RouteContext context, List<ActionRequestValue> requests, List<ActionItem> generatedActionItems, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) throws WorkflowException {
        requests = new ArrayList<ActionRequestValue>(requests);
        Collections.sort(requests, new Utilities.PrioritySorter());
        String activationType = nodeInstance.getRouteNode().getActivationType();
        if (StringUtils.isBlank((String)activationType)) {
            activationType = "S";
        }
        boolean isPriorityParallel = "R".equals(activationType);
        boolean isSequential = "S".equals(activationType);
        boolean activatedApproveRequest = false;
        if (CollectionUtils.isNotEmpty(requests)) {
            int currentPriority = requests.get(0).getPriority();
            for (ActionRequestValue request : requests) {
                if (request.getParentActionRequest() != null || request.getNodeInstance() == null) continue;
                if (activatedApproveRequest && (!context.isSimulation() || !context.getActivationContext().isActivateRequests()) && (isSequential || isPriorityParallel && request.getPriority() != currentPriority)) break;
                currentPriority = request.getPriority();
                if (request.isActive()) {
                    activatedApproveRequest = activatedApproveRequest || request.isApproveOrCompleteRequest();
                    continue;
                }
                this.logProcessingMessage(request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Activating request: " + String.valueOf(request));
                }
                activatedApproveRequest = this.activateRequest(context, request, nodeInstance, generatedActionItems, isPriorityParallel) || activatedApproveRequest;
            }
        }
        return activatedApproveRequest;
    }

    protected boolean activateRequest(RouteContext context, ActionRequestValue actionRequest, RouteNodeInstance nodeInstance, List<ActionItem> generatedActionItems, boolean isPriorityParallel) {
        if (actionRequest.isRoleRequest()) {
            List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(actionRequest.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
            for (ActionRequestValue siblingRequest : actionRequests) {
                boolean isSamePriority;
                boolean bl = isSamePriority = !isPriorityParallel || actionRequest.getPriority().equals(siblingRequest.getPriority());
                if (!actionRequest.getRoleName().equals(siblingRequest.getRoleName()) || !isSamePriority) continue;
                KEWServiceLocator.getActionRequestService().activateRequestNoNotification(siblingRequest, context.getActivationContext());
                generatedActionItems.addAll(context.getActivationContext().getGeneratedActionItems());
            }
        }
        actionRequest = KEWServiceLocator.getActionRequestService().activateRequestNoNotification(actionRequest, context.getActivationContext());
        generatedActionItems.addAll(context.getActivationContext().getGeneratedActionItems());
        return actionRequest.isApproveOrCompleteRequest() && !actionRequest.isDone();
    }

    protected ActionRequestValue saveActionRequest(RouteContext context, ActionRequestValue actionRequest) {
        if (!context.isSimulation()) {
            return KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest);
        }
        actionRequest.setActionRequestId(String.valueOf(generatedRequestPriority++));
        context.getEngineState().getGeneratedRequests().add(actionRequest);
        return actionRequest;
    }

    protected DocumentRouteHeaderValue saveDocument(RouteContext context, DocumentRouteHeaderValue document) {
        if (!context.isSimulation()) {
            document = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(document);
            context.setDocument(document);
        }
        return document;
    }

    protected void logProcessingMessage(ActionRequestValue request) {
        if (LOG.isDebugEnabled()) {
            RouteNodeInstance nodeInstance = request.getNodeInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Processing AR: ").append(request.getActionRequestId()).append("\n");
            buffer.append("AR Node Name: ").append(nodeInstance != null ? nodeInstance.getName() : "null").append("\n");
            buffer.append("AR RouteLevel: ").append(request.getRouteLevel()).append("\n");
            buffer.append("AR Request Code: ").append(request.getActionRequested()).append("\n");
            buffer.append("AR Request priority: ").append(request.getPriority()).append("\n");
            LOG.debug((CharSequence)buffer);
        }
    }
}

