/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.feedback.web;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailTo;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.feedback.web.FeedbackForm;
import org.kuali.rice.kew.mail.service.EmailContentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class FeedbackAction
extends KewKualiAction {
    private static final Logger LOG = LogManager.getLogger(FeedbackAction.class);

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FeedbackForm feedbackForm = (FeedbackForm)form;
        feedbackForm.setTimeDate(new Date().toString());
        feedbackForm.setComments("");
        String documentType = request.getParameter("docType");
        if (documentType == null) {
            documentType = "";
        }
        feedbackForm.setDocumentType(documentType);
        String pageUrl = request.getParameter("pageUrl");
        if (pageUrl == null) {
            pageUrl = "";
        }
        feedbackForm.setPageUrl(pageUrl);
        String documentId = request.getParameter("documentId");
        if (documentId == null) {
            documentId = "";
        }
        feedbackForm.setDocumentId(documentId);
        String exception = request.getParameter("exception");
        if (exception == null) {
            feedbackForm.setException("");
            feedbackForm.setCategory("");
        } else {
            feedbackForm.setCategory("problem");
            feedbackForm.setException(exception);
        }
        UserSession uSession = FeedbackAction.getUserSession();
        Person workflowUser = uSession.getPerson();
        if (workflowUser != null) {
            feedbackForm.setNetworkId(workflowUser.getPrincipalName());
            feedbackForm.setUserEmail(workflowUser.getEmailAddress());
            String name = workflowUser.getName().trim();
            feedbackForm.setUserName(name);
            String firstName = name.substring(0, name.indexOf(" "));
            String lastName = name.substring(name.lastIndexOf(" ") + 1, name.length());
            feedbackForm.setFirstName(firstName);
            feedbackForm.setLastName(lastName);
        } else {
            feedbackForm.setNetworkId("");
            feedbackForm.setUserEmail("");
            feedbackForm.setUserName("");
            feedbackForm.setFirstName("");
            feedbackForm.setLastName("");
        }
        return mapping.findForward("start");
    }

    public ActionForward sendFeedback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FeedbackForm feedbackForm = (FeedbackForm)form;
        EmailContentService emailContentService = KEWServiceLocator.getEmailContentService();
        String fromAddress = this.determineFromAddress(emailContentService, feedbackForm);
        String toAddress = emailContentService.getApplicationEmailAddress();
        EmailContent content = emailContentService.generateFeedback(feedbackForm);
        CoreApiServiceLocator.getMailer().sendEmail(new EmailFrom(fromAddress), new EmailTo(toAddress), new EmailSubject(content.getSubject()), new EmailBody(content.getBody()), content.isHtml());
        return mapping.findForward("sent");
    }

    private String determineFromAddress(EmailContentService emailContentService, FeedbackForm form) {
        DocumentType docType = null;
        if (!StringUtils.isEmpty((String)form.getDocumentType()) && (docType = KEWServiceLocator.getDocumentTypeService().findByName(form.getDocumentType())) == null) {
            LOG.warn("Couldn't locate document type for the given name to determine feedback from address! " + form.getDocumentType());
        }
        return emailContentService.getDocumentTypeEmailAddress(docType);
    }

    private static UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }
}

