/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityAttribute;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityDirective;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityHandlerService;

public class DocumentSecurityHandlerServiceImpl
implements DocumentSecurityHandlerService {
    private ExtensionRepositoryService extensionRepositoryService;

    public List<String> getAuthorizedDocumentIds(String principalId, List<DocumentSecurityDirective> documentSecurityDirectives) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (documentSecurityDirectives == null) {
            documentSecurityDirectives = Collections.emptyList();
        }
        ArrayList<String> authorizedDocumentIds = new ArrayList<String>();
        HashMap<String, DocumentSecurityAttribute> securityAttributeCache = new HashMap<String, DocumentSecurityAttribute>();
        for (DocumentSecurityDirective documentSecurityDirective : documentSecurityDirectives) {
            List<DocumentSecurityAttribute> attributesToApply = this.loadSecurityAttributes(documentSecurityDirective, securityAttributeCache);
            block1: for (Document document : documentSecurityDirective.getDocuments()) {
                if (authorizedDocumentIds.contains(document.getDocumentId())) continue;
                for (DocumentSecurityAttribute securityAttribute : attributesToApply) {
                    if (!securityAttribute.isAuthorizedForDocument(principalId, document)) continue;
                    authorizedDocumentIds.add(document.getDocumentId());
                    continue block1;
                }
            }
        }
        return authorizedDocumentIds;
    }

    protected List<DocumentSecurityAttribute> loadSecurityAttributes(DocumentSecurityDirective documentSecurityDirective, Map<String, DocumentSecurityAttribute> securityAttributeCache) {
        ArrayList<DocumentSecurityAttribute> securityAttributes = new ArrayList<DocumentSecurityAttribute>();
        for (String documentSecurityAttributeName : documentSecurityDirective.getDocumentSecurityAttributeNames()) {
            securityAttributes.add(this.loadAndCacheSecurityAttribute(documentSecurityAttributeName, securityAttributeCache));
        }
        return securityAttributes;
    }

    protected DocumentSecurityAttribute loadAndCacheSecurityAttribute(String securityAttributeName, Map<String, DocumentSecurityAttribute> securityAttributeCache) {
        if (securityAttributeCache.containsKey(securityAttributeName)) {
            return securityAttributeCache.get(securityAttributeName);
        }
        ExtensionDefinition extensionDefinition = this.extensionRepositoryService.getExtensionByName(securityAttributeName);
        if (extensionDefinition == null) {
            throw new RiceIllegalArgumentException("Failed to locate a SecurityAttribute with the given name: " + securityAttributeName);
        }
        DocumentSecurityAttribute securityAttribute = this.loadSecurityAttribute(extensionDefinition);
        securityAttributeCache.put(securityAttributeName, securityAttribute);
        return securityAttribute;
    }

    protected DocumentSecurityAttribute loadSecurityAttribute(ExtensionDefinition extensionDefinition) {
        Object securityAttribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        if (securityAttribute == null) {
            throw new RiceIllegalArgumentException("Failed to load SecurityAttribute for: " + String.valueOf(extensionDefinition));
        }
        return (DocumentSecurityAttribute)securityAttribute;
    }

    public ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }
}

