/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.common.delegate.DelegationTypeService;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class RouteLogDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService,
DelegationTypeService {
    public static final String INITIATOR_ROLE_NAME = "Initiator";
    public static final String INITIATOR_OR_REVIEWER_ROLE_NAME = "Initiator or Reviewer";
    public static final String ROUTER_ROLE_NAME = "Router";

    protected boolean isCheckRequiredAttributes() {
        return true;
    }

    protected List<String> getRequiredAttributes() {
        ArrayList<String> required = new ArrayList<String>(super.getRequiredAttributes());
        required.add("documentNumber");
        return required;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String documentId;
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (roleName == null) {
            throw new RiceIllegalArgumentException("roleName was null");
        }
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (qualification != null && !qualification.isEmpty() && StringUtils.isNotBlank((String)(documentId = qualification.get("documentNumber")))) {
            try {
                WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
                if (INITIATOR_ROLE_NAME.equals(roleName)) {
                    String principalId = KewApiServiceLocator.getWorkflowDocumentService().getDocumentInitiatorPrincipalId(documentId);
                    RoleMembership roleMembership = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)MemberType.PRINCIPAL, null).build();
                    members.add(roleMembership);
                } else if (INITIATOR_OR_REVIEWER_ROLE_NAME.equals(roleName)) {
                    List ids = KewApiServiceLocator.getWorkflowDocumentActionsService().getPrincipalIdsInRouteLog(documentId, true);
                    for (String id : ids) {
                        if (!StringUtils.isNotBlank((String)id)) continue;
                        RoleMembership roleMembership = RoleMembership.Builder.create(null, null, (String)id, (MemberType)MemberType.PRINCIPAL, null).build();
                        members.add(roleMembership);
                    }
                } else if (ROUTER_ROLE_NAME.equals(roleName)) {
                    String principalId = workflowDocumentService.getRoutedByPrincipalIdByDocumentId(documentId);
                    RoleMembership roleMembership = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)MemberType.PRINCIPAL, null).build();
                    members.add(roleMembership);
                }
            }
            catch (Exception wex) {
                throw new RuntimeException("Error in getting principal Ids in route log for document id: " + documentId + " :" + wex.getLocalizedMessage(), wex);
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (groupIds == null) {
            throw new RiceIllegalArgumentException("groupIds was null or blank");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        this.validateRequiredAttributesAgainstReceived(qualification);
        boolean isUserInRouteLog = false;
        if (qualification != null && !qualification.isEmpty()) {
            String documentId = qualification.get("documentNumber");
            WorkflowDocumentService workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
            try {
                if (INITIATOR_ROLE_NAME.equals(roleName)) {
                    isUserInRouteLog = principalId.equals(workflowDocumentService.getDocumentInitiatorPrincipalId(documentId));
                } else if (INITIATOR_OR_REVIEWER_ROLE_NAME.equals(roleName)) {
                    isUserInRouteLog = KewApiServiceLocator.getWorkflowDocumentActionsService().isUserInRouteLog(documentId, principalId, true);
                } else if (ROUTER_ROLE_NAME.equals(roleName)) {
                    isUserInRouteLog = principalId.equals(workflowDocumentService.getRoutedByPrincipalIdByDocumentId(documentId));
                }
            }
            catch (Exception wex) {
                throw new RuntimeException("Error in determining whether the principal Id: " + principalId + " is in route log for document id: " + documentId + " :" + wex.getLocalizedMessage(), wex);
            }
        }
        return isUserInRouteLog;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        return true;
    }
}

