/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.dao.DocumentRouteHeaderDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class DocumentRouteHeaderDAOJpa
implements DocumentRouteHeaderDAO {
    private static final Logger LOG = LogManager.getLogger(DocumentRouteHeaderDAOJpa.class);
    private static final String LOCK_TIMEOUT_HINT = "javax.persistence.lock.timeout";
    private static final Long DEFAULT_LOCK_TIMEOUT_SECONDS = 3600L;
    public static final String GET_APP_DOC_ID_NAME = "DocumentRouteHeaderValue.GetAppDocId";
    public static final String GET_APP_DOC_ID_QUERY = "SELECT d.appDocId from DocumentRouteHeaderValue as d where d.documentId = :documentId";
    public static final String GET_APP_DOC_STATUS_NAME = "DocumentRouteHeaderValue.GetAppDocStatus";
    public static final String GET_APP_DOC_STATUS_QUERY = "SELECT d.appDocStatus from DocumentRouteHeaderValue as d where d.documentId = :documentId";
    public static final String GET_DOCUMENT_HEADERS_NAME = "DocumentRouteHeaderValue.GetDocumentHeaders";
    public static final String GET_DOCUMENT_HEADERS_QUERY = "SELECT d from DocumentRouteHeaderValue as d where d.documentId IN :documentIds";
    public static final String GET_DOCUMENT_STATUS_NAME = "DocumentRouteHeaderValue.GetDocumentStatus";
    public static final String GET_DOCUMENT_STATUS_QUERY = "SELECT d.docRouteStatus from DocumentRouteHeaderValue as d where d.documentId = :documentId";
    public static final String GET_DOCUMENT_ID_BY_DOC_TYPE_APP_ID_NAME = "DocumentRouteHeaderValue.GetDocumentIdByDocTypeAndAppId";
    public static final String GET_DOCUMENT_ID_BY_DOC_TYPE_APP_ID_QUERY = "SELECT DISTINCT(DH.documentId) FROM DocumentRouteHeaderValue DH, DocumentType DT WHERE DH.appDocId = :appDocId AND DH.documentTypeId = DT.documentTypeId  AND DT.name = :name";
    private EntityManager entityManager;
    private DataSource dataSource;
    private DataObjectService dataObjectService;

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds) {
        if (documentIds.isEmpty()) {
            return new ArrayList<DocumentRouteHeaderValue>();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(GET_DOCUMENT_HEADERS_NAME, DocumentRouteHeaderValue.class);
        query.setParameter("documentIds", documentIds);
        return query.getResultList();
    }

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds, boolean clearCache) {
        Collection<DocumentRouteHeaderValue> documentRouteHeaderValues = this.findRouteHeaders(documentIds);
        if (clearCache) {
            for (DocumentRouteHeaderValue drhv : documentRouteHeaderValues) {
                this.getEntityManager().refresh((Object)drhv);
            }
        }
        return documentRouteHeaderValues;
    }

    @Override
    public void lockRouteHeader(String documentId) {
        HashMap<String, Long> options = new HashMap<String, Long>();
        options.put(LOCK_TIMEOUT_HINT, this.getTimeoutMilliseconds());
        this.getEntityManager().find(DocumentRouteHeaderValue.class, (Object)documentId, LockModeType.PESSIMISTIC_WRITE, options);
    }

    protected Long getTimeoutMilliseconds() {
        Long secondsToWait = DEFAULT_LOCK_TIMEOUT_SECONDS;
        String timeoutValue = ConfigContext.getCurrentContextConfig().getDocumentLockTimeout();
        if (timeoutValue != null) {
            try {
                secondsToWait = Long.parseLong(timeoutValue);
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse document lock timeout as it was not a valid number: " + timeoutValue, (Throwable)e);
            }
        }
        return secondsToWait * 1000L;
    }

    @Override
    public DocumentRouteHeaderValue findRouteHeader(String documentId, boolean clearCache) {
        DocumentRouteHeaderValue dv = (DocumentRouteHeaderValue)this.getDataObjectService().find(DocumentRouteHeaderValue.class, (Object)documentId);
        if (clearCache) {
            this.getEntityManager().refresh((Object)dv);
        }
        return dv;
    }

    @Override
    public String getNextDocumentId() {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.getDataSource(), (String)"KREW_DOC_HDR_S");
        return incrementer.nextStringValue();
    }

    @Override
    public Collection<String> findPendingByResponsibilityIds(Set<String> responsibilityIds) {
        ArrayList<String> documentIds = new ArrayList<String>();
        if (responsibilityIds.isEmpty()) {
            return documentIds;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("ActionRequestValue.FindPendingByResponsibilityIds", String.class);
        query.setParameter("respIds", responsibilityIds);
        return query.getResultList();
    }

    @Override
    public void clearRouteHeaderSearchValues(String documentId) {
        Query query = this.getEntityManager().createNamedQuery("SearchableAttributeValue.FindSearchableAttributesByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        List searchableAttributeValues = query.getResultList();
        for (SearchableAttributeValue sa : searchableAttributeValues) {
            this.getDataObjectService().delete((Object)sa);
        }
    }

    @Override
    public Collection<SearchableAttributeValue> findSearchableAttributeValues(String documentId) {
        Query query = this.getEntityManager().createNamedQuery("SearchableAttributeValue.FindSearchableAttributesByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public DocumentRouteHeaderValueContent getContent(String documentId) {
        DocumentRouteHeaderValueContent content = null;
        Query query = this.getEntityManager().createNamedQuery("DocumentRouteHeaderValueContent.FindByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            content = (DocumentRouteHeaderValueContent)query.getResultList().get(0);
        }
        return content;
    }

    @Override
    public boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey, String searchableAttributeValue) {
        Query query = this.getEntityManager().createNamedQuery("SearchableAttributeValue.HasSearchableAttributeValue");
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("searchableAttributeKey", (Object)searchableAttributeKey);
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            for (Object ob : query.getResultList()) {
                SearchableAttributeValue sav = (SearchableAttributeValue)ob;
                if (!StringUtils.equals((String)sav.getSearchableAttributeDisplayValue(), (String)searchableAttributeValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDocumentStatus(String documentId) {
        String status = null;
        Query query = this.getEntityManager().createNamedQuery(GET_DOCUMENT_STATUS_NAME);
        query.setParameter("documentId", (Object)documentId);
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            status = (String)query.getResultList().get(0);
        }
        return status;
    }

    @Override
    public void save(SearchableAttributeValue searchableAttribute) {
        this.getDataObjectService().save((Object)searchableAttribute, new PersistenceOption[0]);
    }

    @Override
    public String getAppDocId(String documentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery(GET_APP_DOC_ID_NAME, String.class);
        query.setParameter("documentId", (Object)documentId);
        String applicationDocId = null;
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            applicationDocId = (String)query.getResultList().get(0);
        }
        return applicationDocId;
    }

    @Override
    public String getApplicationIdByDocumentId(String documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("Encountered a null document ID.");
        }
        String applicationId = null;
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.GetAppIdByDocumentId", String.class);
        query.setParameter("documentId", (Object)documentId);
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            applicationId = (String)query.getResultList().get(0);
        }
        return applicationId;
    }

    @Override
    public String getAppDocStatus(String documentId) {
        String applicationDocumentStatus = null;
        TypedQuery query = this.getEntityManager().createNamedQuery(GET_APP_DOC_STATUS_NAME, String.class);
        query.setParameter("documentId", (Object)documentId);
        if (query.getResultList() != null && !query.getResultList().isEmpty()) {
            applicationDocumentStatus = (String)query.getResultList().get(0);
        }
        return applicationDocumentStatus;
    }

    @Override
    public Collection findByDocTypeAndAppId(String documentTypeName, String appId) {
        TypedQuery query = this.getEntityManager().createNamedQuery(GET_DOCUMENT_ID_BY_DOC_TYPE_APP_ID_NAME, String.class);
        query.setParameter("appDocId", (Object)appId);
        query.setParameter("name", (Object)documentTypeName);
        return query.getResultList();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

